/**
 *
 * @event b-description-popup#save-click клик на кнопке "Сохранить"
 *
 * @fires b-description-popup#save-click
 */
BEM.DOM.decl('b-description-popup', {

    onSetMod: {

        js: function() {
            this._iRequest = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                dataType: 'text',
                callbackCtx: this
            });

            this._options = this.params && this.params.options || {};

            this._getPopup()
                .on('hide', this._onPopupHide, this)
                .on('show', this._onPopupShow, this);
        },

        loading: function(modName, modVal) {
            this._getSpin().setMod('progress', modVal);

            if (modVal == 'yes') {
                var form = this.elem('form');

                this.elem('spin').css({
                    width: form.width(),
                    height: form.height()
                });
            } else {
                this.elem('spin').css({
                    width: 'auto',
                    height: 'auto'
                });
            }
        }
    },

    _iRequset: null,

    _options: null,

    _descData: null,

    _toggleElem: null,

    toggle: function(toggleElem, descData) {
        var popup = this._getPopup();

        if (popup.isShown()) {
            popup.hide();
        } else {
            descData.text || (descData.text = '');

            this._descData = descData;
            this._toggleElem = toggleElem;

            this._getInput().val(descData.text);

            popup.show(toggleElem);
        }

        return this;
    },

    /**
     * Сохранение примечания
     * Генерация события сохранения
     * @returns {this}
     */
    save: function() {
        var currentValue = this._getInput().val(),
            descData = this._descData;

        this.trigger('save-click');

        if (currentValue !== descData.text) {
            var dataForSave = $.extend({}, this._options, { description: currentValue });

            dataForSave[descData.idField || 'id'] = descData['id'];

            this.setMod('loading', 'yes');
            this._iRequest.get(dataForSave, this._onSuccess, this._onError);
        } else {
            this.toggle();
        }

        return this;
    },

    _onSuccess: function() {
        this
            .toggle()
            .trigger('change', {
                index: this._descData.index,
                domElem: this._toggleElem,
                text: this._getInput().val()
            })
            .delMod('error')
    },

    _onError: function() {
        this
            .delMod('loading')
            .setMod('error', 'yes');
    },

    _onPopupHide: function() {
        this
            .delMod('error')
            .delMod('loading');
    },

    _onPopupShow: function() {
        this._getInput().setMod('focused', 'yes');
    },

    _input: null,

    _getInput: function() {
        return this._input || (this._input = this.findBlockOn('input', 'input'));
    },

    _popup: null,

    _getPopup: function() {
        return this._popup || (this._popup = this.findBlockOn('popup'));
    },

    _bSpin: null,

    _getSpin: function() {
        return this._bSpin || (this._bSpin = this.findBlockInside('spin', 'spin'));
    }

}, {

    live: function() {
        this
            .liveBindTo('save', 'click', function(e) {
                this.save(e);
            })
            .liveBindTo('cancel', 'click', function(e) {
                this.toggle();
            })
    }

});
