block('b-dev-info')(

    content()(function() {
        var data = this.data,
            cid = data.cid || (data.campaign && data.campaign.cid),
            userLogin = data.user_login,
            uname = data.uname,
            svnInfo = data.svn_info || {},
            owner = (userLogin && uname && uname != userLogin) || data.real_login ? userLogin : null,
            usedPage = this.ctx.usedPage,
            block = usedPage.block,
            mods = usedPage.mods,
            modName = mods ? Object.keys(mods)[0] : '',
            modVal = modName ? mods[modName] : '';

        return [
            {
                elem: 'item',
                name: 'page block',
                content: block + (modName ? '_' + modName + '_' + modVal : '')
            },
            {
                elem: 'item',
                name: 'svn',
                content: svnInfo.branch + ' (r' + svnInfo.revision + ')'
            },
            {
                elem: 'item',
                name: 'cmd',
                content: data.FORM.cmd
            },
            data.client_role ?
                {
                    elem: 'item',
                    name: 'client_role',
                    content: data.client_role
                } :
                '',
            cid && userLogin ?
                {
                    elem: 'item',
                    name: 'cid',
                    content: {
                        block: 'b-link',
                        url: u.getUrl('showCamp', {
                            cid: cid,
                            ulogin: userLogin
                        }),
                        content: cid
                    }
                } :
                '',
            owner ?
                {
                    elem: 'item',
                    name: 'owner',
                    content: {
                        block: 'b-link',
                        url: u.getUrl('showCamps', {
                            ulogin: owner
                        }),
                        content: owner
                    }
                } :
                '',
            {
                elem: 'item',
                name: 'templating',
                content: data.is_external_templating == 1 ? 'ynode' : 'perl v8'
            },
            {
                block: 'b-dev-profile-log-info',
                url: u.getUrl('devGetProfileLogInfo', {
                    reqid: data.reqid
                })
            },
            ' ',
            {
                block: 'dropdown',
                content: [
                    {
                        block: 'link',
                        mods: {
                            pseudo: 'yes'
                        },
                        mix: [
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            },
                            {
                                block: 'header2',
                                elem: 'config'
                            }
                        ],
                        content: 'admin links'
                    },
                    {
                        elem: 'popup',
                        js: {
                            directions: 'top-left'
                        },
                        elemMods: { adaptive: 'no' },
                        content: {
                            block: 'b-admin-quick-links'
                        }
                    }
                ]
            }
        ];
    }),

    elem('item').def()(function() {
        return [
            this.ctx.name + ': ',
            {
                elem: 'debug-value',
                content: this.ctx.content
            },
            '&nbsp;&nbsp;'
        ];
    })
);
