BEM.DOM.decl({ block: 'b-device-targeting', implements: 'i-outboard-controls' }, {

    /**
     * Проставляет значения чекбоксам в дереве, в зависимости от значения поля device_targeting модели
     */
    loadTargeting: function() {
        this.findBlocksInside('b-checkbox-tree-item').forEach(function(item) {
            var value = item.checkbox.val();

            // если ничего не указано, то это все устройства
            if (value != 'no')
                item.toggle(!this.targeting || this.targeting.indexOf(value) > -1);
        }, this);
    },

    //region i-outboard-controls interface methods

    /**
     * Метод подготовки формы. Будет вызван при каждом показе формы
     * @param {Object} params параметры вызова, переданные из интерфейса i-outboard-controls
     * @param {Object} params.modelId идентификатор модели
     * @param {Object} [params.modelName] имя модели кампании
     */
    prepareToShow: function(params) {
        this._model = BEM.MODEL.getOne({ name: params.modelName || 'm-campaign', id: params.modelId });
        this.targeting = this._model.get('device_targeting');
        this.loadTargeting();
    },

    /**
     * Метод, вызываемый, когда будет нажата кнопка ОК
     */
    provideData: function() {
        var devices = this.findBlocksInside('checkbox')
            .filter(function(checkbox) {
                return checkbox.isChecked() && checkbox.val() != 'no';
            });

        if (devices.length > 0) {

            this._model.set('device_targeting', devices.map(function(checkbox) {
                return checkbox.val();
            }).join(','));
        } else {
            BEM.blocks['b-confirm'].open({
                hideClose: true,
                message: iget2('b-device-targeting', 'nelzya-otklyuchit-targeting-na', 'Нельзя отключить таргетинг на всех устройствах'),
                type: 'alert',
                onYes: function() {
                    this.loadTargeting();
                }
            }, this);

            return false;
        }
    },

    /**
     * Метод, вызываемый, когда будет нажата кнопка Отмена
     */
    declineChange: function() {
        // ничего не делаем
    }

    //endregion i-outboard-controls interface methods

}, {
    live: true
});
