block('b-disabled-ips')(

    def()(function() {
        this.MAX_IPS_COUNT = 25;

        return applyNext();
    }),

    js()(function() {
        return { MAX_IPS_COUNT: this.MAX_IPS_COUNT };
    }),

    content()(function() {
        return [
            {
                tag: 'p',
                content: [
                    iget2('b-disabled-ips', 'vnosit-ip-adresa-v', 'Вносить IP-адреса в список можно через запятую или через пробел.'),
                    '<br/>',
                    iget2(
                        'b-disabled-ips',
                        'obshchee-kolichestvo-zapreshchennyh-ip',
                        'Общее количество запрещенных IP-адресов не может превышать {foo}.',
                        {
                            foo: this.MAX_IPS_COUNT
                        }
                    )
                ]
            },
            '<br/>',
            {
                block: 'input',
                mix: { block: 'b-disabled-ips', elem: 'input' },
                mods: { autofocus: 'yes' },
                content: { elem: 'control' }
            },
            '&nbsp;',
            {
                block: 'button',
                mods: { shadow: 'yes' },
                type: 'button',
                content: iget2('b-disabled-ips', 'dobavit', 'Добавить')
            },
            {
                elem: 'list',
                disabledIps: this.ctx.disabledIps
            }
        ];
    }),

    elem('list').content()(function() {
        return this.ctx.disabledIps
            .split(/[\s,]+/g)
            .filter(function(a) {
                return a;
            })
            .map(function(ip, i) {
                return {
                    block: 'b-disabled-ips',
                    elem: 'ip',
                    ip: ip
                };
            });
    }),

    elem('ip').content()(function() {
        return {
            block: 'checkbox',
            mods: { checked: 'yes' },
            checkboxAttrs: {
                value: this.ctx.ip,
                tabindex: 1
            }, // атрибуты чекбокса
            text: this.ctx.ip
        };
    })
);
