BEM.DOM.decl({ block: 'b-disabled-ips', implements: 'i-outboard-controls' }, {
    onSetMod: {
        js: function() {
            this.MAX_IPS_COUNT = this.params.MAX_IPS_COUNT || 25;

            this.input = this.findBlockInside('input');

            this.findBlockInside('button').on('click', this._addIps, this);
            this.input.bindTo(this.input.elem('control'), 'keypress', this._onKeyPress.bind(this));
        }
    },

    //region i-outboard-controls interface methods

    /**
     * Метод подготовки формы. Будет вызван при каждом показе формы
     * @param {Object} params параметры вызова, переданные из интерфейса i-outboard-controls
     * @param {Object} params.modelId идентификатор модели m-campaign
     */
    prepareToShow: function(params) {
        this.input.val('');

        this._model = BEM.MODEL.getOrCreate(params && params.modelParams || 'm-campaign');

        BEM.DOM.destruct(this.findElem('list'));
        BEM.DOM.append(this.domElem, BEMHTML.apply({
            block: 'b-disabled-ips',
            elem: 'list',
            disabledIps: this._model.get('disabledIps')
        }));
    },

    /**
     * Метод, вызываемый, когда будет нажата кнопка ОК
     */
    provideData: function() {
        this._model.set('disabledIps', this._getIps().join(', '));
        this._model.fields.disabledIps.fixData();
        return true;
    },

    /**
     * Метод, вызываемый, когда будет нажата кнопка Отмена
     */
    declineChange: function() {
        // ничего не делаем
    },

    //endregion i-outboard-controls interface methods

    _onKeyPress: function(event) {
        if (event.keyCode == 13) {
            this._addIps();
            return false;
        }

        return true;
    },

    /**
     * Возвращает список IP адресов
     * @returns {Array} массив строк - IP аресов
     * @private
     */
    _getExistingIps: function() {
        return this.findBlocksInside('checkbox')
            .map(function(checkbox) {
                return checkbox.val();
            });
    },

    /**
     * Возвращает список выбранных IP аресов
     * @returns {Array} массив строк - IP аресов
     * @private
     */
    _getIps: function() {
        return this.findBlocksInside('checkbox')
            .filter(function(checkbox) {
                return checkbox.isChecked();
            })
            .map(function(checkbox) {
                return checkbox.val();
            });
    },

    /**
     * Возвращает количество активных IP адресов
     * @returns {Number}
     * @private
     */
    _getCheckedCount: function() {
        return this._getIps().length;
    },

    /**
     * Добавляет IP адреса, введенные в поле ввода
     * @private
     */
    _addIps: function() {
        var value = this.input.val().trim(),
            isIPv4 = BEM.blocks['i-utils'].isIPv4,
            existedIps = this._getExistingIps(),
            newIps = [],
            invalidIps = [],
            invalidString;

        // проверка, что поле не пустое
        if (value.length === 0)
            return;

        // разбиваем адреса на валидные и невалидные
        value.split(/[\s,]+/g).forEach(function(ip) {
            if (isIPv4(ip)) {
                newIps.push(ip);
            } else {
                invalidIps.push(ip);
            }
        });

        // проверяем, что общее количество адресов (кроме тех, с которых сняты галки) не превышает лимит
        if (this._getCheckedCount() + newIps.length + invalidIps.length > this.MAX_IPS_COUNT) {
            this._showAlert(iget2(
                'b-disabled-ips',
                'prevysheno-dopustimoe-kolichestvo-zapreshchennyh',
                'Превышено допустимое количество запрещенных IP-адресов: {foo}',
                {
                    foo: this.MAX_IPS_COUNT
                }
            ));
            return;
        }

        // Добавляем новые валидные айпишники в список
        BEM.DOM.prepend(
            this.findElem('list'),
            newIps
                .filter(function(ip) {
                    return existedIps.indexOf(ip) == -1; // проверка на отсутствие в списке
                })
                .map(function(ip) {
                    return BEMHTML.apply({
                        block: 'b-disabled-ips',
                        elem: 'ip',
                        ip: ip
                    });
                }).join('')
        );

        // оставляем невалидные айпишники внутри инпута
        invalidString = invalidIps.join(', ');
        if (invalidIps.length)
            this._showAlert(iget2('b-disabled-ips', 'neverno-ukazany-ip-adresa', 'Неверно указаны IP адреса {foo}', {
                foo: u.escapeHTML(invalidString)
            }));
        this.input.val(invalidString);
    },

    /**
     * Показывает алерт при помощи b-confim блока
     * @param {String} message
     * @private
     */
    _showAlert: function(message) {
        BEM.blocks['b-confirm'].open({
            hideClose: true,
            message: message,
            type: 'alert',
            onYes: function() {
                this.input.setMod('focused', 'yes');
            }.bind(this)
        });
    }

}, {
    live: true
});
