BEM.DOM.decl({ block: 'b-display-map-chooser' }, {

    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOne(this.params.modelParams);

            BEM.blocks['i-web-api-request'].placements
                .get({
                    ulogin: u.consts('ulogin'),
                    placementType: 'INDOOR'
                })
                .then(function(data) {
                    this._formatDictionary(data);
                    this._formatToMapData(data);
                    this._updatePreview();
                    this.removeSpin();
                }.bind(this))
                .catch(function(error) {
                    this.removeSpin();
                });
        }
    },

    addSpin: function() {
        this.findBlockInside(this.elem('switcher'), 'button2').setMod('disabled', 'yes');

        this.spin = $(BEMHTML.apply({
            mix: { block: 'b-display-map-chooser', elem: 'spin' },
            block: 'spin',
            mods: { theme: 'gray-16' }
        })).bem('spin');

        BEM.DOM.append(this.elem('switcher-wrap'), this.spin.domElem);

        this.spin.setMod('progress', 'yes');

        return this;
    },

    removeSpin: function() {
        this.findBlockInside(this.elem('switcher'), 'button2').delMod('disabled');

        if (!this.spin) return this;

        this.spin.destruct();
        this.spin = null;

        return this;
    },

    _formatToMapData: function(data) {
        var selectedByProvider = this._splitSelectedByProvider(this.params.selected),
            goodPlacementBlocks,
            screenGroupsByRegion = {},
            placements = {},
            byPageZone = {};

        data.placements.reduce(function(result, placements) {
            if (placements.type === 'INDOOR') {
                result[placements.id] = {
                    id: placements.id,
                    name: placements.operatorName,
                    deleted: placements.deleted,
                    caption: placements.caption
                }
            }

            return result;
        }, placements);

        goodPlacementBlocks = data.placement_blocks.filter(function(block) {
            var pageId = block.pageId,
                isDeleted = !!(placements[pageId] && placements[pageId].deleted) ||
                    !!block.deleted || !!block.hidden,
                isSelectedPlatform = u._.isEmpty(selectedByProvider[pageId]) ?
                    false :
                    (selectedByProvider[pageId].indexOf(block.blockId.toString()) !== -1);

            block.isDeleted = isDeleted;

            return !!block.geoId && !!block.coordinates && (!isDeleted || isSelectedPlatform);
        });

        goodPlacementBlocks.forEach(function(block) {
            var id = block.pageId + '-' + block.zoneCategory,
                geoId = block.geoId;

            if (!byPageZone[block.geoId]) {
                byPageZone[geoId] = [];
            }

            if (!byPageZone[geoId][id]) {
                byPageZone[geoId][id] = [];
            }

            byPageZone[geoId][id].push(block);
        });

        u._.keys(byPageZone).reduce(function(result, regionId) {
            var groups = byPageZone[regionId];

            screenGroupsByRegion[regionId] = u._.keys(groups).map(function(groupId) {
                var screens = groups[groupId],
                    first = screens[0];

                return {
                    id: groupId,
                    zoneCategory: first.zoneCategory,
                    facilityType: first.facilityType,
                    coordinates: first.coordinates.split(/,\s?/),
                    address: first.address || '',
                    gid: first.blockCaption,
                    regionId: regionId,
                    caption: placements[first.pageId].caption,
                    screens: screens.map(function(screen) {
                        return {
                            isDeleted: screen.isDeleted,
                            aspectRatio: screen.aspectRatio,
                            id: screen.pageId + '-' + screen.blockId,
                            screenWeight: 1,
                            address: first.address || ''
                        }
                    })
                }
            });

            return result;
        }, screenGroupsByRegion);

        return this._screenGroupsByRegion = screenGroupsByRegion;
    },

    _formatDictionary: function(data) {
        var langKey,
            regions = {};

        switch (BEM.blocks['i-global'].param('locale')) {
            case 'en':
                langKey = 'nameEn';
                break;
            case 'tr':
                langKey = 'nameTr';
                break;
            case 'uk':
                langKey = 'nameUa';
                break;
            case 'ru':
                langKey = 'nameRu';
                break;
            default:
                langKey = 'nameRu';
        }

        u._.keys(data.region_dictionary).reduce(function(result, id) {
            result[id] = {
                id: id,
                text: data.region_dictionary[id][langKey]
            };

            return result;
        }, regions);

        return this._dictionary = {
            zone: data.zone_dictionary,
            facility: data.facility_dictionary,
            region: regions
        };
    },

    _splitSelectedByProvider: function(selected) {
        var selectedByProvider = {};

        selected.forEach(function(id) {
            id = id.split('-');

            var platformId = id[0],
                providerId = id[1];

            if (!selectedByProvider[providerId]) {
                selectedByProvider[providerId] = [];
            }

            selectedByProvider[providerId].push(platformId);
        });

        return selectedByProvider;
    },

    _onPopupSave: function(checkedByRegion) {
        var selectedScreens = [],
            screenGroupsByRegion = this._screenGroupsByRegion;

        u._.keys(checkedByRegion).map(function(regionId) {
            var groups = screenGroupsByRegion[regionId];

            checkedByRegion[regionId].forEach(function(id) {
                var group = u._.find(groups, { id: id });

                if (group) {
                    group.screens.forEach(function(screen) {
                        var id = screen.id.split('-');

                        selectedScreens.push({
                            pageId: id[0],
                            blockId: id[1]
                        })
                    });
                }
            });
        });

        this._selectedFromPopup = checkedByRegion;

        this._updatePreview();

        this.trigger('save', {
            selected: selectedScreens
        });

    },

    _getSelected: function() {
        var screenGroupsByRegion = this._screenGroupsByRegion,
            selected = {},
            regions;

        if (this._selectedFromPopup) {
            return this._selectedFromPopup;
        } else {
            regions = u._.keys(this._screenGroupsByRegion);

            (this.params.selected || []).forEach(function(id) {
                id = id.split('-');

                var pageId = id[1],
                    blockId = id[0],
                    screenId = pageId + '-' + blockId,
                    isSelected = false;

                regions.map(function(regionId) {
                    if (isSelected) { return; }

                    var groups = screenGroupsByRegion[regionId],
                        group;

                    for (var groupIndex = 0; groupIndex < groups.length; groupIndex++) {
                        group = groups[groupIndex];
                        isSelected = !!u._.find(group.screens, { id: screenId });

                        if (isSelected) {
                            selected[regionId] || (selected[regionId] = []);
                            selected[regionId].push(group.id);
                            break;
                        }
                    }
                });
            }, this);

            return this._selectedFromPopup = u._.keys(selected).reduce(function(result, regionId) {
                result[regionId] = u._.uniq(selected[regionId]);

                return result;
            }, {});
        }
    },

    _getPreviewData: function() {
        var selected = this._getSelected(),
            screenGroupsByRegion = this._screenGroupsByRegion,
            dictionary = this._dictionary;

        return u._.keys(selected).reduce(function(result, regionId) {
            var region = screenGroupsByRegion[regionId],
                screensCount = 0;

            result.push({
                name: dictionary.region[regionId].text,
                regionId: regionId,
                items: selected[regionId].map(function(id) {
                    var group = u._.find(region, { id: id }),
                        facility = dictionary.facility[group.facilityType],
                        zone = dictionary.zone[group.zoneCategory];

                    screensCount += group.screens.length;

                    return {
                        name: group.caption,
                        operator: facility.charAt(0).toUpperCase() + facility.slice(1) +
                            ' · ' + zone.charAt(0).toUpperCase() + zone.slice(1),
                        address: group.address.charAt(0).toUpperCase() + group.address.slice(1)
                    };
                }),
                screensCount: screensCount
            });

            return result;
        }, []);
    },

    _updatePreview: function() {
        BEM.DOM.replace(this.findElem('preview'), BEMHTML.apply({
            block: 'b-outdoor-map-preview',
            mods: { type: 'indoor' },
            mix: {
                block: 'b-display-map-chooser',
                elem: 'preview'
            },
            selectedByRegions: this._getPreviewData()
        }));

    },

    /**
     * Обработчик нажатия на кнопку открытия попапа
     * @private
     */
    _onSwitcherClick: function() {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator']
                .create({ type: 'indoor-map-popup', without: 'max-height' }, { bodyScroll: false }),
            subMan = BEM.create('i-subscription-manager'),
            outdoorPopup = popupDecorator
                .setPopupContent({
                    block: 'indoor-map-popup',
                    js: {
                        screenGroupsByRegion: this._screenGroupsByRegion,
                        selectedScreens: this._getSelected(),
                        dictionary: this._dictionary,
                        adgroup_id: this.model.get('modelId'),
                        campaign_id: this.model.get('cid'),
                        video_creative_ids: this.model.getBanners().map(function(banner) {
                            return banner.get('creative').get('creative_id');
                        }),
                        isNewGroup: this.model.get('isNewGroup'),
                        hierarchical_multipliers: u._.pick(this.model.getMultipliersData(), 'demography_multiplier')
                    }
                });

        subMan
            .on(outdoorPopup, 'save', function(e, data) {
                this._onPopupSave(data);
                popupDecorator.hide({ force: true });
            }, this)
            .on(outdoorPopup, 'cancel', function() {
                popupDecorator.hide({ force: true });
            }, this)
            .on(popupDecorator, 'close-blocked', function(e) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-experiments-settings', 'close-popup-message', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .on(popupDecorator, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                popupDecorator.destruct();
            }, this);

        popupDecorator.show();

        // @skywhale
        // понижаем индекс popup большого директа, что бы не перекрывал popup из DNA
        popupDecorator.getPopup().domElem.css('zIndex', 999);
        popupDecorator.getPopup()._under.css('zIndex', 999);
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('switcher').is(e.block.domElem) && this._onSwitcherClick(e, data);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
