BEM.DOM.decl({ block: 'b-dna-preview-gallery' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this.smartGroupsPreviewModel = BEM.MODEL.getOne('dm-smart-groups-preview');

            this.smartGroupsPreviewModel.on('previewsData', 'change', this._onPreviewDataChange, this);
        }
    },

    _onPreviewDataChange: function() {
        var data = this.smartGroupsPreviewModel.get('previewsData'),
            previewsData = data && data[this.params.groupId],
            dna = window.dna;

        if (previewsData) {
            this._renderDna(dna, {
                groupId: this.params.groupId,
                offers: previewsData.offers,
                logo: previewsData.logo,
            });
        } else {
            this._renderError();
        }
    },

    _renderDna: function(dna, params) {
        var dnaComp = this._getDnaComponent(dna, params),
            domElem = this.domElem.get(0);

        BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
            dna.reactDOMRender(dnaComp, domElem);
        });
    },

    _getDnaComponent: function(dna, params) {
        return dna.reactCreateElement(dna.components.PreviewGalleryForSmartGroupsWrapper, {
            login: u.consts('ulogin'),
            groupId: params.groupId,
            offers: params.offers,
            logo: params.logo,
            clientFeatures: u.consts('clientFeaturesAll'),
            operatorFeatures: u.consts('operatorFeaturesAll'),
            cspNonce: BEM.blocks['i-global'].param('nonce'),
        }, null);
    },

    _renderError: function() {
        BEM.DOM.replace(this.findElem('spin-container'), BEMHTML.apply({
            block: 'b-dna-preview-gallery',
            elem: 'error-container',
            content: {
                block: 'b-dna-preview-gallery',
                elem: 'error',
                content: iget2('b-dna-preview-gallery', 'error-text', 'Не удалось загрузить превью')
            }
        }));
    },

    destruct: function() {
        this.smartGroupsPreviewModel.un('previewsData', 'change', this._onPreviewDataChange, this);
    }
});
