BEM.DOM.decl({ block: 'b-dna-strategy' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this._renderDna(dna, this.params);
        }
    },

    _renderDna: function(dna, params) {
        var dnaComp = this._getDnaComponent(dna, params),
            domElem = this.domElem.get(0);

        BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
            dna.reactDOMRender(dnaComp, domElem);
        });
    },

    _getDnaComponent: function(dna, params) {
        if (u.hasClientFeature('package_strategies_enabled') && params.strategyId !== '0') {
            return dna.reactCreateElement(dna.components.PackageStrategyEditorWrapper, {
                strategyId: params.strategyId,
                login: u.consts('ulogin')
            }, null);
        }

        return dna.reactCreateElement(dna.components.StrategyEditorWrapper, {
            campaignId: params.campaignId
        }, null);
    }
});
