BEM.DOM.decl({ block: 'b-dont-show-domains', modName: 'type', modVal: 'video', implements: 'i-outboard-controls' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
        }
    },

    prepareToShow: function(params) {
        this._campModel = BEM.MODEL.getOrCreate(params && params.modelParams);

        var domains = this._campModel.get('disabled_video_placements');

        this.filterYandexSitesCheck();

        this._getInternalSites(domains);

        this._input.val('');
        this._renderList({
            domains: { items: domains, checked: domains },
            ssp: { items: [], checked: [] }
        });
    },

    provideData: function() {
        var limit = this._getLimitPlatforms();

        if (this._getAllCheckedItemsCount() > limit) {
            this._showLimitWarning(limit);

            return false;
        }

        this._campModel
            .set('disabled_video_placements', this._getChecked('domain'))
            .set(
                'require_filtration_by_dont_show_domains',
                this.findBlockOn('filter-yandex-sites', 'checkbox').isChecked()
            );
    }

});
