block('b-dont-show-domains')(

    js()(function() {
        return {
            needOuterNets: this.ctx.needOuterNets === undefined ? true : this.ctx.needOuterNets,
            isMCBanner: this.ctx.isMCBanner,
            isContentPromotion: this.ctx.isContentPromotion,
            allowWhitelistedDomains: this.ctx.allowWhitelistedDomains
        };
    }),

    content()(function() {
        var needOuterNets = this.ctx.needOuterNets === undefined ? true : this.ctx.needOuterNets,
            isMCBanner = this.ctx.isMCBanner,
            isContentPromotion = this.ctx.isContentPromotion,
            isCpm = this.ctx.isCpm,
            allowWhitelistedDomains = this.ctx.allowWhitelistedDomains,
            allowRequireFiltrationByDontShowDomain = this.ctx.allowRequireFiltrationByDontShowDomain &&
                !isMCBanner && !isContentPromotion,
            requireFiltrationByDontShowDomains = this.ctx.requireFiltrationByDontShowDomains,
            isVideo = this.mods.type === 'video';

        return [
            {
                elem: 'info',
                content: (function() {
                    if (isMCBanner || isContentPromotion) {
                        return iget2('b-dont-show-domains', 'mc-banner-exclude-sites', 'Вы можете запретить показы на Поиске Рамблера.{line-break}Для этого введите rambler.ru.{appendix}', {
                            appendix: allowWhitelistedDomains ? '' : iget2(
                                'b-dont-show-domains',
                                'search-exception',
                                '{line-break}Показы на Яндекс.Поиске и Поиске Mail.Ru запретить нельзя.', {
                                    'line-break': '<br/>'
                                }
                            ),
                            'line-break': '<br/>'
                        })
                    }
                    if (isVideo) {
                        return iget2('b-dont-show-domains', 'video-exclude-sites', 'Вы можете отключить показ видеорекламы на сайтах и в приложениях, указав их через запятую.{appendix}', {
                            appendix: iget2(
                                'b-dont-show-domains',
                                'nets-exception',
                                '{line-break}Запрет на площадки Яндекса и турбо-сайты не применяется в сетях.', {
                                    'line-break': '<br/>'
                                }
                            ),
                            'line-break': '<br/>'
                        })
                    }

                    return iget2('b-dont-show-domains', 'other-exclude-sites', 'Вы можете отключить показ рекламы на сайтах и в приложениях, указав их через запятую.{appendix1}{appendix2}', {
                        appendix1: allowWhitelistedDomains ? '' : iget2(
                            'b-dont-show-domains',
                            'search-exception',
                            '{line-break}Показы на Яндекс.Поиске и Поиске Mail.Ru запретить нельзя.', {
                                'line-break': '<br/>'
                            }
                        ),
                        appendix2: iget2(
                            'b-dont-show-domains',
                            'nets-exception',
                            '{line-break}Запрет на площадки Яндекса и турбо-сайты не применяется в сетях.', {
                                'line-break': '<br/>'
                            }
                        ),
                        'line-break': '<br/>'
                    })
                })()
            },
            {
                elem: 'add',
                content: [
                    allowRequireFiltrationByDontShowDomain == '1' && {
                        block: 'checkbox',
                        mods: { checked: requireFiltrationByDontShowDomains ? 'yes' : '' },
                        mix: [{
                            block: 'b-dont-show-domains',
                            elem: 'filter-yandex-sites'
                        }],
                        checkboxAttrs: { value: 'require_filtration_by_dont_show_domains' },
                        text: allowWhitelistedDomains || isVideo ?
                            iget2('b-dont-show-domains', 'filter-yandex-sites', 'Дать возможность запрещать площадки Яндекса') :
                            iget2('b-dont-show-domains', 'filter-yandex-search', 'Дать возможность запрещать площадки Яндекса, кроме Поиска')
                    },
                    {
                        block: 'input',
                        mix: [{
                            block: 'b-dont-show-domains',
                            elem: 'input'
                        }],
                        content: { elem: 'control' }
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-dont-show-domains',
                            elem: 'add'
                        }],
                        content: iget2('b-dont-show-domains', 'dobavit', 'Добавить')
                    }
                ]
            },
            { elem: 'list-wraper' },
            {
                block: 'tooltip',
                mods: {
                    size: 'xs',
                    theme: 'normal'
                },
                js: { to: ['left', 'bottom', 'top'], zIndexGroupLevel: 6 },
                mix: {
                    block: 'b-dont-show-domains',
                    elem: 'tooltip'
                },
                content: {
                    block: 'b-dont-show-domains',
                    elem: 'tooltip-text',
                    content: [
                        iget2('b-dont-show-domains', 'chtoby-zapretit-ploshchadki-vvedite', 'Чтобы запретить площадки, введите их домены, например:'),
                        {
                            block: 'b-dont-show-domains',
                            elem: 'examples',
                            content: 'auto.ru, music.yandex.ru'
                        },
                        needOuterNets && iget2('b-dont-show-domains', 'chtoby-zapretit-vneshnie-seti', 'Чтобы запретить внешние сети, введите их названия, например:'),
                        needOuterNets && {
                            block: 'b-dont-show-domains',
                            elem: 'examples',
                            content: 'Smaato'
                        },
                        isCpm && iget2('b-dont-show-domains', 'tooltip-text-mobile', 'Чтобы запретить мобильные приложения, введите их идентификаторы, например: {mobile}', {
                            mobile: {
                                block: 'b-dont-show-domains',
                                elem: 'examples',
                                content: 'id502838820, ru.photostrana.mobile'
                            }
                        })
                    ]
                }
            },
            {
                block: 'tooltip',
                js: { to: 'right' },
                mods: {
                    size: 'xs',
                    theme: 'error'
                },
                mix: {
                    block: 'b-dont-show-domains',
                    elem: 'internal-sites-tooltip'
                },
                content: iget2('b-dont-show-domains', 'cannot-block-internal-sites', 'При показе в сетях нельзя запретить площадки Яндекса')
            }
        ];
    }),

    elem('list').content()(function() {
        var domains = this.ctx.domains,
            ssp = this.ctx.ssp,
            internalSites = this.ctx.internalSites || [],
            first = {},
            count = {
                all: domains.items.length + ssp.items.length,
                checked: domains.checked.length + ssp.checked.length,
                domainsAll: domains.items.length,
                sspAll: ssp.items.length
            },
            isInternal;

        // если у нас больше одной площадки, то возвращаем дерево с одним уровнем вложенности
        if (count.all > 1) {

            return {
                block: 'b-checkbox-tree',
                items: [
                    {
                        label: iget2('b-dont-show-domains', 'vse', 'Все'),
                        checked: count.all == count.checked,
                        mix: [{
                            block: 'b-dont-show-domains',
                            elem: 'all'
                        }],
                        subsMix: [{
                            block: 'b-dont-show-domains',
                            elem: 'items'
                        }],
                        subs: [].concat(
                            ssp.items.map(function(name) {
                                var isInternal = u._.includes(internalSites, name);

                                return {
                                    label: u.escapeHTML(name),
                                    checked: ssp.checked.indexOf(name) > -1,
                                    checkboxAttrs: { value: name },
                                    mix: [
                                        {
                                            block: 'b-dont-show-domains',
                                            elem: 'ssp'
                                        },
                                        isInternal && {
                                            block: 'b-dont-show-domains',
                                            elem: 'internal-site'
                                        }
                                    ]
                                };
                            }),
                            domains.items.map(function(domain) {
                                var isInternal = u._.includes(internalSites, domain);

                                return {
                                    label: u.escapeHTML(domain),
                                    checked: domains.checked.indexOf(domain) > -1,
                                    checkboxAttrs: { value: domain },
                                    mix: [
                                        {
                                            block: 'b-dont-show-domains',
                                            elem: 'domain'
                                        },
                                        isInternal && {
                                            block: 'b-dont-show-domains',
                                            elem: 'internal-site'
                                        }
                                    ]
                                };
                            }))
                    }
                ]
            };
        }

        // если площадка всего одна, то нам нужен только чекбокс
        if (count.all === 1) {
            if (count.domainsAll == 1) {
                first.elem = 'domain';
                first.value = domains.items[0];
                first.checked = domains.checked.indexOf(first.value) > -1;
            }

            if (count.sspAll == 1) {
                first.elem = 'ssp';
                first.value = ssp.items[0];
                first.checked = ssp.checked.indexOf(first.value) > -1;
            }

            isInternal = u._.includes(internalSites, first.value);

            return {
                block: 'checkbox',
                mods: { checked: first.checked ? 'yes' : '' },
                mix: [
                    {
                        block: 'b-dont-show-domains',
                        elem: first.elem
                    },
                    isInternal && {
                        block: 'b-dont-show-domains',
                        elem: 'internal-site'
                    }
                ],
                checkboxAttrs: { value: first.value },
                text: first.value
            };
        }

        return '';
    })
);
