BEM.DOM.decl({ block: 'b-dont-show-domains', implements: 'i-outboard-controls' }, {

    onSetMod: {
        js: function() {
            var isMCBanner = this.params.isMCBanner,
                isContentPromotion = this.params.isContentPromotion;

            this._input = this.findBlockOn('input', 'input');

            this._tooltip = this
                .findBlockInside('tooltip', 'tooltip')
                .setOwner(this._input);

            this._internalSitesTooltip = this
                .findBlockInside('internal-sites-tooltip', 'tooltip');

            if (!isMCBanner && !isContentPromotion) {
                this._input.on('change focus blur', this._toggleTooltip, this);
            }

            // обрабатываем инпут при клике на кнопку или нажатии на enter
            this._input.bindTo(this._input.elem('control'), 'keypress', this._onKeyPress.bind(this));
            this.findBlockOn('add', 'button').on('click', function() {
                this._processInput();
            }, this);

            this._internalSites = [];
        }
    },

    //region i-outboard-controls interface methods

    prepareToShow: function(params) {
        this._campModel = BEM.MODEL.getOrCreate(params && params.modelParams || 'm-campaign');

        var domains = this._campModel.get('DontShow'),
            ssp = this._campModel.get('disabled_ssp');

        this.filterYandexSitesCheck();

        this._getInternalSites([].concat(domains, ssp));

        this._input.val('');
        this._renderList({
            domains: { items: domains, checked: domains },
            ssp: { items: ssp, checked: ssp }
        });
    },

    provideData: function() {
        var limit = this._getLimitPlatforms(),
            filterCheckbox = this.findBlockOn('filter-yandex-sites', 'checkbox');

        if (this._getAllCheckedItemsCount() > limit) {
            this._showLimitWarning(limit);

            return false;
        }

        this._campModel
            .set('DontShow', this._getChecked('domain'))
            .set('disabled_ssp', this._getChecked('ssp'))

        if (filterCheckbox) {
            this._campModel.set('require_filtration_by_dont_show_domains', filterCheckbox.isChecked());
        }
    },

    filterYandexSitesCheck: function() {
        var isChecked = this._campModel.get('require_filtration_by_dont_show_domains'),
            checkbox = this.findBlockOn('filter-yandex-sites', 'checkbox');

        if (checkbox && checkbox.isChecked() !== isChecked) {
            checkbox.toggle();
        }
    },

    declineChange: function() {
        // ничего не делаем
    },

    /**
     * Показывает/скрывает tooltip
     * @private
     */
    _toggleTooltip: function() {
        if (this._input.hasMod('focused', 'yes')) {
            this._tooltip.toggleMod('shown', 'yes', '', !this._input.val());
        } else {
            this._tooltip.delMod('shown');
        }
    },

    //endregion i-outboard-controls interface methods

    /**
     * Отрисовывает список доменов/названия сетей
     * @param {Object} data
     * @param {Array} data.domains - домены
     * @param {Array} data.ssp - названия сетей
     * @private
     */
    _renderList: function(data) {
        BEM.DOM.update(this.elem('list-wraper'),
            BEMHTML.apply({
                block: 'b-dont-show-domains',
                elem: 'list',
                domains: data.domains,
                ssp: data.ssp,
                internalSites: this._internalSites
            }));
    },

    /**
     * Обработчик нажатия кнопки Enter
     * @param {Object} event событие
     * @returns {Boolean}
     * @private
     */
    _onKeyPress: function(event) {
        if (event.keyCode == 13) {
            this._processInput();

            return false;
        }

        return true;
    },

    _showLimitWarning: function(limit) {
        BEM.blocks['b-confirm'].alert(iget2(
            'b-dont-show-domains',
            'vy-mozhete-otklyuchit-ne-bolee-ploshadok',
            'Вы можете отключить не более {limit} площадки',
            {
                limit: limit,
                count: limit,
                some: 'Вы можете отключить не более {limit} площадок',
                many: 'Вы можете отключить не более {limit} площадок'
            }
        ));
    },

    /**
     * Добавляет площадки в список, фильтрует неправильные и выводит предупреждения
     * @private
     */
    _processInput: function() {
        var domainsInputString = this._input.val(),
            utils = BEM.blocks['i-utils'],
            confirm = BEM.blocks['b-confirm'],
            dirty = this._convertToDirtyArray(domainsInputString),
            good = {
                domains: [],
                ssp: []
            },
            bad = [],
            errors = {
                invalid: [],
                whiteList: [],
                common: [],
                maxLen: []
            },
            errorsHtml = '',
            limit = this._getLimitPlatforms();

        // проверка на количество
        if (dirty.length + this._getAllCheckedItemsCount() > limit) {
            this._showLimitWarning(limit);

            return;
        }

        // пробегаем по всем потенциальным площадкам
        dirty.forEach(function(text) {
            var ssp = this._searchAvailableSsp(text),
                domain;

            if (ssp) {
                good.ssp.push(ssp);

                // если содержится в словаре ssp, проверку домена пропускаем
                return;
            }

            // очищаем от www.
            domain = $.trim(utils.stripWww(utils.extractDomain(text)));

            // проверка на валидность домена
            if (!u.isUrl(domain) && !u.isAppId(domain)) {
                errors.invalid.push(u.escapeHTML(domain));
                bad.push(domain);

            // проверка на нахождение в белом списке (такие домены нельзя отключать)
            } else if (!this.params.allowWhitelistedDomains && this._inWhiteList(domain)) {
                errors.whiteList.push(domain);
                bad.push(domain);

            // проверка, что домен является доменом общего использования
            } else if (domain.match('^(\\*\\.)?' + utils.commonDomainRegExp + '$')) {
                errors.common.push(domain);
                bad.push(domain);

            // проверка длины домена
            } else if (domain.length >= 255) {
                errors.maxLen.push(domain);
            } else {
                good.domains.push(domain);
            }
        }, this);

        // выводим все ошибки разом
        errorsHtml = this._generateErrorsHtml(errors);
        if (errorsHtml.length) confirm.alert(errorsHtml);

        // валидные площадки добавляем
        this._addPlatforms(good);

        // DIRECT-53033: 9950 При добавлении доменов кнопкой Enter тултип показывается после добавления
        if (good.ssp.length || good.domains.length) {
            this._unbindTooltip();
        }

        // оставляем невалидные площадки в инпуте, чтобы пользователь мог их подредактировать
        this._input.val(bad.join(', '));
    },

    /**
     * Отписывает тултип от инпута
     * @private
     */
    _unbindTooltip: function() {
        this._input.un('change focus blur', this._toggleTooltip, this);
    },

    /**
     * Возвращает название площадки, если она содержится в словаре
     * @param {String} text
     * @returns {Null|String}
     * @private
     */
    _searchAvailableSsp: function(text) {
        var ssp = null;

        this._campModel
            .get('ssp_platforms')
            .some(function(platform) {
                return platform.toLowerCase() == text && (ssp = platform);
            });

        return ssp;
    },

    /**
     * Получает объект с массивами плохих площадок, выдает HTML для отображения ошибок
     * @param {Object} errors ошибки
     * @param {String[]} errors.invalid если домен или название сети неверны
     * @param {String[]} errors.whiteList если домен в белом списке
     * @param {String[]} errors.common если домен общего использования
     * @param {String[]} errors.maxLen если длина выше максимума
     * @returns {String}
     * @private
     */
    _generateErrorsHtml: function(errors) {
        var errorsMessages = [],
            needOuterNets = this.params.needOuterNets;

        // Собираем сообщения об ошибках правильные
        if (errors.invalid.length === 1)
            errorsMessages.push(needOuterNets ?
                iget2('b-dont-show-domains', 'neverno-ukazana-ploshchadka-vneshnyaya', 'Неверно указана площадка/внешняя сеть: {foo}', {
                    foo: errors.invalid[0]
                }) :
                iget2('b-dont-show-domains', 'neverno-ukazana-ploshchadka-s', 'Неверно указана площадка: {foo}', {
                    foo: errors.invalid[0]
                })
            );

        if (errors.invalid.length > 1)
            errorsMessages.push(needOuterNets ?
                iget2('b-dont-show-domains', 'neverno-ukazany-ploshchadki-vneshnie', 'Неверно указаны площадки/внешние сети: {foo}', {
                    foo: errors.invalid.join(', ')
                }) :
                iget2('b-dont-show-domains', 'neverno-ukazany-ploshchadki-s', 'Неверно указаны площадки: {foo}', {
                    foo: errors.invalid.join(', ')
                })
            );

        if (errors.whiteList.length === 1)
            errorsMessages.push(iget2('b-dont-show-domains', 'otklyuchat-pokazy-na-ploshchadke', 'Отключать показы на площадке {foo} нельзя.', {
                foo: errors.whiteList[0]
            }));

        if (errors.whiteList.length > 1)
            errorsMessages.push(iget2('b-dont-show-domains', 'otklyuchat-pokazy-na-ploshchadkah', 'Отключать показы на площадках {foo} нельзя.', {
                foo: errors.whiteList.join(', ')
            }));

        if (errors.common.length)
            errorsMessages.push(
                iget2(
                    'b-dont-show-domains',
                    'nelzya-otklyuchat-pokazy-dlya',
                    'Нельзя отключать показы для доменов общего использования: {foo}',
                    {
                        foo: errors.common.join(', ')
                    }
                ));

        if (errors.maxLen.length === 1)
            errorsMessages.push(iget2(
                'b-dont-show-domains',
                'prevyshena-maksimalno-dopustimaya-dlina',
                'Превышена максимально допустимая длина домена: {foo}',
                {
                    foo: errors.maxLen[0].slice(0, 30)
                }
            ) + '&hellip;');

        if (errors.maxLen.length > 1)
            errorsMessages.push(iget2(
                'b-dont-show-domains',
                'prevyshena-maksimalno-dopustimaya-dlina',
                'Превышена максимально допустимая длина домена: {foo}',
                {
                    foo: errors.maxLen.map(function(domain) {
                        return domain.slice(0, 30) + '&hellip;';
                    }).join(', ')
                }
            ));

        return errorsMessages.join('<br/>');
    },

    /**
     * Возвращает список уже добавленных площадок
     * @param {String} elemName - тип площадок
     * @returns {Array}
     * @private
     */
    _getExisting: function(elemName) {
        return this
            .findBlocksInside(elemName, 'checkbox')
            .map(function(cbx) { return cbx.val() });
    },

    /**
     * Возвращает список отмеченных площадок
     * @param {String} elemName - тип площадок
     * @returns {Array} домены/названия сетей
     * @private
     */
    _getChecked: function(elemName) {
        return this
            .findBlocksInside(elemName, 'checkbox')
            .filter(function(d) { return d.isChecked() })
            .map(function(cbx) { return cbx.val() });
    },

    /**
     * Добавляет новые площадки в список
     * @param {Object} platforms
     * @param {Array} platforms.domains
     * @param {Array} platforms.ssp
     * @private
     */
    _addPlatforms: function(platforms) {
        var existingDomains = this._getExisting('domain'),
            existingSsp = this._getExisting('ssp'),
            newDomains,
            newSsp,
            sites;

        // оставляем из площадок те, которые еще не были добавлены
        newDomains = u._.uniq(platforms.domains)
            .filter(function(nd) {
                return existingDomains.indexOf(nd) == -1;
            });

        newSsp = u._.uniq(platforms.ssp)
            .filter(function(nd) {
                return existingSsp.indexOf(nd) == -1;
            });

        sites = [].concat(existingDomains, newDomains, existingSsp, newSsp);

        this._getInternalSites(sites);

        this._internalSitesTooltip
            .setOwner(this);

        this._renderList({
            domains: {
                items: newDomains.concat(existingDomains),
                checked: newDomains.concat(this._getChecked('domain'))
            },
            ssp: {
                items: newSsp.concat(existingSsp),
                checked: newSsp.concat(this._getChecked('ssp'))
            }
        });
    },

    /**
     * Преобразует строку инпута в список возможных площадок для дальней валидации
     * @param {String} input строка введенная пользователем
     * @returns {Array} список слов
     */
    _convertToDirtyArray: function(input) {
        return input ?
            this._clearSequence(input.toLowerCase()).split(/[,]+/) :
            [];
    },

    /**
     * Удаляет двойные пробелы и начальные/концевые пробелы
     * @param {String} str
     * @returns {String}
     * @private
     */
    _clearString: function(str) {
        return (str + '').replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
    },

    /**
     * Чистит строку вида "aaa, bbb, cccc" и приводит к виду "aaa,bbb,cccc"
     * @param {String} str
     * @returns {String}
     * @private
     */
    _clearSequence: function(str) {
        return this._clearString(str).replace(/,\s+/g, ',').replace(/,$/g, '');
    },

    /**
     * Проверяет домен на принадлежность белому списку (нельзя отключить показы на нём)
     * @param {String} domain
     * @param {Boolean} [noAlert] показывать ли алерт
     * @returns {Boolean} true если domain из белого списка
     */
    _inWhiteList: function(domain, noAlert) {
        if (domain.match(/^((m|www)\.)?((direct)\.)?(yandex|ya)\.[a-z]+\.?[a-z]*$/i) ||
            // eslint-disable-next-line require-iget2
            domain.toLowerCase() == 'яндекс.рф' || domain.toLowerCase() == 'xn--d1acpjx3f.xn--p1ai' ||
            domain.match(/^((go|www|)\.)?mail\.ru/)) {

            return true;
        }

        return false;
    },

    /**
     * Возвращает максимальное кол-во запрещенных площадок
     * @returns {Number}
     * @private
     */
    _getLimitPlatforms: function() {
        return this.params.limitPlatforms || u.consts('limitPlatforms');
    },

    /**
     * Возвращает количество уже добавленных выбранных площадок
     * @returns {Number} количество доменов
     * @private
     */
    _getAllCheckedItemsCount: function() {
        var domains = this._getChecked('domain') || [],
            ssp = this._getChecked('ssp') || [];

        return domains.length + ssp.length;
    },

    _getInternalSites: function(sites) {
        BEM.blocks['i-web-api-request'].disabledDomains.getInternalPagesDomains(u.consts('ulogin'), sites)
            .then(function(internalSites) {
                this._internalSites = internalSites;

                this._renderList({
                    domains: {
                        items: this._getExisting('domain'),
                        checked: this._getChecked('domain')
                    },
                    ssp: {
                        items: this._getExisting('ssp'),
                        checked: this._getChecked('ssp')
                    }
                });
            }.bind(this));
    }

}, {
    live: function() {
        this
            .liveBindTo('internal-site', 'pointerover', function(e) {
                this._internalSitesTooltip
                    .setOwner($(e.target).bem('checkbox'))
                    .setMod('shown', 'yes');
            })
            .liveBindTo('internal-site', 'pointerout', function() {
                this._internalSitesTooltip
                    .delMod('shown');
            });
        return false;
    }
});
