u.register({

    'b-dont-show-domains': {

        /**
         * Разбивает заблокированные площадки на ssp и домены т.к. решение с одной строкой DontShow, наверно, временное
         * @param {String|Array} [platforms] - заблокированные площадки
         * @param {Array} [sspDictionary] - доступные ssp-площадки
         * @returns {{disabledDomains: Array, sspDictionary: *, disabledSsp: Array}}
         */
        separatePlatforms: function(platforms, sspDictionary) {
            // DIRECT-51455: Поддержка SSP. Интерфейс. Блокирование площадок
            // от сервера нам приходит DontShow в котором содержится ssp и домены,
            // отдать серверу мы должны тоже одной строкой.
            var disabledSsp = [],
                disabledDomains = [],
                disabledPlatforms = (platforms && platforms.split && platforms.split(',')) || platforms || [];

            sspDictionary || (sspDictionary = []);

            disabledPlatforms.forEach(function(platform) {
                // ищем название платформы в словаре доступных ssp
                var isSsp = sspDictionary.some(function(ssp) {
                    return ssp == platform;
                });

                isSsp ?
                    disabledSsp.push(platform) :
                    disabledDomains.push(platform);
            });

            return {
                disabledDomains: disabledDomains,
                sspDictionary: sspDictionary,
                disabledSsp: disabledSsp
            };
        }

    }

});
