/**
 * @typedef DragChooserItem перетаскиваемый элемент для b-drag-chooser
 * @property {String} text лейбл чекбокса
 * @property {String} value значение чекбокса
 */

/**
 * @param {DragChooserItem[]} this.ctx.items перетаскиваемые элементы
 * @param {String[]} [this.ctx.value] идентификаторы выбранных пунктов
 * @param {String[]} [this.ctx.positions] идентификаторы пунктов в порядке их расположения
 * @param {Object} [this.ctx.disabledValues] отключенные (disabled_yes) чекбоксы
 * @param {Object} [this.ctx.lockedValues] заблокированные (disabled_yes + checked_yes) чекбоксы
 * @param {Object} [this.ctx.checkParams] параметры для чекбоксов
 * @param {String} [this.ctx.checkParams.mix] микс для всех чекбоксов блока
 */
block('b-drag-chooser')(

    tag()('ul'),

    content()(function() {
        var ctx = this.ctx,
            items = u._.compact(ctx.items || []),
            positions = ctx.positions || [],
            disabledValues = this.ctx.disabledValues || {},
            lockedValues = this.ctx.lockedValues || {},
            checkParams = u._.pick(ctx.checkParams || {}, 'mix'),
            checkedItems = (ctx.value || []).reduce(function(acc, c) {
                acc[c] = true;
                return acc;
            }, {});

        // Создаем список пунктов
        items = items.reduce(function(elems, item) {
            var value = item.value,
                checked = checkedItems[value],
                index = positions.indexOf(value);

            // Если есть индекс - записываем элемент на положенное место
            // Если индекса нет - просто добавляем в конец
            elems[~index ? index : elems.length] = {
                elem: 'item',
                checkParams: u._.extend({
                    checked: checked || (lockedValues[value] && !disabledValues[value]),
                    value: value,
                    disabled: disabledValues[value] || lockedValues[value]
                }, checkParams),
                help: item.help,
                text: item.text
            };

            return elems;
        }, u._.fill(positions.slice())); // пустая копия позиций для резервирования мест для элементов, порядок которых мы знаем

        return items;
    })
);
