BEM.DOM.decl('b-drag-chooser', {

    onSetMod: {
        js: function() {
            this._initNestable();
            this._bindCheckboxes();
        }
    },

    /**
     * Инициализация плагина Nestable для drag'n'drop.a элементов списка
     * @private
     */
    _initNestable: function() {
        var uniqId = this.params.uniqId,
            nestClass = this.__self.buildClass('nest', uniqId);

        // Устанавливаем модификатор nest с id блока для инициализации Nestable
        this.setMod('nest', uniqId);

        // Настройки nestable
        this.domElem.nestable({
            maxDepth: 1,
            listNodeName: 'ul',
            itemNodeName: 'li',
            rootClass: nestClass,
            listClass: nestClass,
            itemClass: this.__self.buildClass('item'),
            handleClass: this.__self.buildClass('handle'),
            dragClass: this.__self.buildClass('dragel'),
            placeClass: this.__self.buildClass('placeholder')
        });
    },

    /**
     * Отписываемся от change блоков checkbox
     * @private
     */
    _unbindCheckboxes: function() {
        BEM.blocks['checkbox'].un(this.domElem, 'change', this._onCheckboxChange, this);
    },

    /**
     * Подписываемся на change блоков checkbox
     * @private
     */
    _bindCheckboxes: function() {
        BEM.blocks['checkbox'].on(this.domElem, 'change', this._onCheckboxChange, this);
    },

    /**
     * Устанавливает состояние checked (lock) и disabled чекбоксам
     * @param {Object} states
     * @param {Object} states.lock
     * @param {Object} states.disable
     */
    setCheckboxesStates: function(states) {
        // На время операций с состоянием чекбоксов отписываемся от событий
        this._unbindCheckboxes();

        this._getAllCheckboxes().forEach(function(check) {
            var val = check.val();

            if (states.disable[val]) {
                check.setMod('checked', states.disable[val] ? '' : 'yes');
            }

            if (states.lock[val]) {
                check.setMod('checked', states.disable[val] ? '' : 'yes');
            }

            check.setMod('disabled', states.disable[val] || states.lock[val] ? 'yes' : '');
        });

        // Подписываемся обратно
        this._bindCheckboxes();
    },

    /**
     * @private
     * @type {BEM[]}
     */
    _allCheckboxes: null,

    /**
     * Возвращает все чекбоксы
     * @returns {BEM[]}
     */
    _getAllCheckboxes: function() {
        return this._allCheckboxes || (this._allCheckboxes = this.findBlocksInside('checkbox'));
    },

    /**
     * Сбрасывает закэшированный список чекбоксов
     * @private
     */
    _dropCacheCheckboxes: function() {
        this._allCheckboxes = null;
    },

    /**
     * Метод возвращает value выбранных пунктов в виде массива, соблюдая их порядок.
     * @returns {String[]}
     */
    getValue: function() {
        // Проходим по всем чекбоксам и если они выбранные - возвращаем value
        return this._getAllCheckboxes().reduce(function(acc, check) {
            check.isChecked() && acc.push(check.val());

            return acc;
        }, []);
    },

    /**
     * Метод возвращает массив с порядком расположения всех пунктов
     * @returns {String[]}
     */
    getPositions: function() {
        // Проходим по всем чекбоксам и возвращаем их значение
        return this._getAllCheckboxes().map(function(check) {

            return check.val();
        });
    },

    /**
     * Обработчик BEM-события `change` на блоках `checkbox`
     * @private
     */
    _onCheckboxChange: function() {
        this.trigger('change', { value: this.getValue() });
    },

    /**
     * Обработчик DOM-события `change` на блоке (срабатывает и на `change` инпутов внутри)
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSomeDOMChange: function(e, data) {
        // Если `change` случился именно на DOM-ноде блока
        if (e.target === e.data.domElem[0]) {
            this._onDragNDropItem(e, data);
        }
    },

    /**
     * Обработчик перетаскивания элемента
     * @private
     */
    _onDragNDropItem: function() {
        this._dropCacheCheckboxes();
    }

}, {

    live: function() {
        // @cyn: слушаем событие `change`, которое триггерит плагин nestable на DOM-ноде блока
        this.liveBindTo('change', function(e, data) {
            this._onSomeDOMChange(e, data);
        });

        return false;
    }

});
