block('b-dropdown-filter')(
    def()(function() {
        var items = this.ctx.items.reduce(function(o, item) {
            o[item.value] = item.text;

            return o;
        }, {});

        return applyCtx({
            block: 'dropdown',
            mix: (this.ctx.mix || []).concat([{
                block: 'b-dropdown-filter',
                js: u._.extend(this.ctx.js || {}, { items: items })
            }]),
            content: [
                {
                    block: 'link',
                    mods: {
                        pseudo: 'yes',
                        'user-select': 'off'
                    },
                    mix: [{
                        block: 'dropdown',
                        elem: 'switcher'
                    }],
                    content: [
                        {
                            block: 'b-dropdown-filter',
                            elem: 'label',
                            tag: 'span'
                        },
                        {
                            block: 'b-dropdown-filter',
                            elem: 'arrow',
                            tag: 'span',
                            content: '&#9660;'
                        }
                    ]
                },
                {
                    elem: 'popup',
                    js: this.ctx.popup && this.ctx.popup.js,
                    elemMods: this.ctx.popup && this.ctx.popup.mods,
                    content: this.ctx.items.map(function(item) {
                        return {
                            block: 'link',
                            mix: [{
                                block: 'b-dropdown-filter',
                                elem: 'item',
                                elemMods: { value: item.value }
                            }],
                            mods: {
                                pseudo: 'yes',
                                'user-select': 'off'
                            },
                            content: item.text
                        };
                    }).concat(
                        this.ctx.footer ?
                            {
                                block: 'b-dropdown-filter',
                                elem: 'footer',
                                content: this.ctx.footer
                            } :
                            []
                    )
                }
            ]
        })
    })
);
