BEM.DOM.decl({ block: 'b-dropdown-filter', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.model.on('value', 'change', function(e, data) {
                this._setLabel(data.value);
            }, this);

            this._itemsMap = this.params.items;

            this._dropdown = this.findBlockOn('dropdown');

            this._setLabel(this.model.get('value'));

            this.bindTo('item', 'click', function(e) {
                this.model.update({
                    value: this.elemInstance(e.data.domElem).getMod('value')
                });

                this._dropdown.hide();
            });
        }
    },

    /**
     * Задаёт текст лэйбла свитчера дропдауна
     * @param {String} value
     * @private
     */
    _setLabel: function(value) {
        var popup = this._dropdown.elem('popup'),
            previous = this.findElem(popup, 'item', 'selected', 'yes'),
            selected = this.findElem(popup, 'item', 'value', value);

        previous.length && this.elemInstance(previous).delMod('selected');

        selected.length && this.elemInstance(selected).setMod('selected', 'yes');

        this.elem('label').text(this._itemsMap[value]);
    }

});
