BEM.DOM.decl({ name: 'b-dropdown-trigger' }, {

    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager')
            .on(this.findBlockInside('b-chooser'), 'select-item', this._onSelectItem, this);
    },

    _onSelectItem: function(e, data) {
        var eventName = this.params.eventName || 'click';

        e.preventDefault();
        e.stopPropagation();

        this.closePopup();
        this.trigger(eventName, data);
    },

    enable: function() {
        this.findBlockInside('dropdown2').delMod('disabled');
    },

    disable: function() {
        this.findBlockInside('dropdown2').setMod('disabled', 'yes');
    },

    closePopup: function() {
        this.getPopup().delMod('visible');
    },

    getPopup: function() {
        return this._popup || (this._popup = this.findBlockInside('dropdown2').getPopup());
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this.getPopup().destruct();
        this.__base.apply(this, arguments);
    }

});
