block('b-dumper')(

    content()(function() {
        this.__disableCheckExpectedProps = true;

        var ctxDump,
            data,
            ctxServerDump;

        data = u._.extend({}, this.data);
        ctxServerDump = data.DUMPVARS;

        delete data.DUMPVARS;

        try {
            // ignore stringify
            ctxDump = JSON.stringify(data);
        } catch (e) {
            ctxDump = '' + e;
            ctxServerDump = '' + e;
        }

        var result = [
            data.COOKIES.dumpvars && ctxDump && [
                {
                    elem: 'title',
                    content: 'ctxDump'
                },
                apply('prepareForPrint', {
                    dump: ctxDump
                })
            ],
            data.COOKIES.get_vars && ctxServerDump && [
                {
                    elem: 'title',
                    content: 'ctxServerDump'
                },
                apply('prepareForPrint', {
                    dump: ctxServerDump
                })
            ]
        ];

        this.__disableCheckExpectedProps = false;

        return result;
    }),

    mode('prepareForPrint')(function() {
        return escapeJs(this.dump)
            .replace(/,/g, ',<br/>')
            .replace(/:(\S)/g, ':&nbsp$1')
            .replace(/{/g, '<span class="b-dumper__hash">{</span><div class="b-dumper__level">')
            .replace(/\[/g, '<span class="b-dumper__array">[</span><div class="b-dumper__level">')
            .replace(/}/g, '</div><span class="b-dumper__hash">}</span>')
            .replace(/\]/g, '</div><span class="b-dumper__array">]</span>');
    })
);
