BEM.DOM.decl({ block: 'b-dynamic-condition-edit', modName: 'page', modVal: 'campaign' }, {
    onSetMod: {
        js: function() {

            u.graspSelf.call(this, {
                _delete: 'button on delete',
                _suspend: 'tumbler on suspend'
            });

            this.__base.apply(this, arguments);
        }
    },

    /**
     * @override {b-dynamic-condition-edit}
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._initCommonEvents();

        this._subscriptionManager.on(this._delete, 'click', this._tryToDeleteCondition, this);

        this._subscriptionManager.on(this._suspend, 'change', this._tryToSuspendCondition, this);

        this._subscriptionManager.wrap(this.model)
            .on('condition condition_name is_suspended', 'change', this._updateCannotSave, this)
            .on('fix', this._updateCannotSave, this);
    },

    /**
     * @override {b-dynamic-condition-edit}
     */
    _updateCannotSave: function() {
        var condition = this.model.get('condition'),
            isEmpty,
            isChanged;

        if (!condition) {
            return false;
        }

        isEmpty = this.model.isEmpty('condition_name') &&
            (!condition.length() || condition.some(function(goal) {
                return !goal.get('value').length;
            })),
        isChanged = ['condition_name', 'condition', 'is_suspended'].some(function(fieldName) {
            return this.model.fields[fieldName].isChanged();
        }, this);

        this.model.set('cantSave', !isChanged || isEmpty || this.hasMod('readonly', 'yes'));
    },

    /**
     * Удаляет условие если оно не является единственным активным, иначе показывает окно с сообщением
     *
     * @event condition:edit:deleted
     * @private
     */
    _tryToDeleteCondition: function() {
        if (!this.model.get('is_suspended') && this.params.isOneActiveConditionInGroup) {
            BEM.blocks['b-confirm'].alert(iget2('b-dynamic-condition-edit', 'nelzya-udalit-poslednee-uslovie', 'Нельзя удалить последнее условие нацеливания'));

            return;
        }
        this.model.set('is_deleted', true);
        this.trigger('condition:edit:deleted');
    },

    /**
     * Выключает условие если оно не является единственным активным, иначе показывает окно с сообщением
     *
     * @param {Object} e событие переключения тумблера
     * @param {Object} data
     * @param {Boolean} data.checked выключен или включен тумблер
     * @event condition:edit:suspended
     * @private
     */
    _tryToSuspendCondition: function(e, data) {
        if (!data.checked && this.params.isOneActiveConditionInGroup) {
            //afterCurrentEvent нужен для корректного переключения тумблера.
            //Если переключать синхронно в обработчике, то это изменение будет перетерто предыдущим значением
            //т.к. setMod сначала вызывает обработчики и лишь затем выставляет модификатор
            this.afterCurrentEvent(function() {
                this._suspend.setMod('checked', 'yes');
            }, this);

            BEM.blocks['b-confirm'].alert(iget2('b-dynamic-condition-edit', 'nelzya-vyklyuchit-poslednee-uslovie', 'Нельзя выключить последнее условие нацеливания'));

            return;
        }

        this.model.set('is_suspended', !data.checked);
        this.trigger('condition:edit:suspended', !data.checked);
    },

    /**
     * Добавляет строку в список условий
     * @param {BEM.MODEL<b-dynamic-goal-edit>} data
     * @override {b-dynamic-condition-edit}
     * @private
     */
    _addConditions: function(data) {
        var canUseUrlProdlistType = this.model.get('canUseUrlProdlistType'),
            parentId = this.model.id;

        this._list.add(data, {
            itemOptions: {
                disableRemove: data.length === 1,
                parentModelName: 'b-dynamic-condition-edit_page_campaign',
                canUseUrlProdlistType: canUseUrlProdlistType,
                parentId: parentId,
                mods: { page: 'campaign' }
            }
        });
    }
});
