BEM.MODEL.decl({ name: 'b-dynamic-condition-edit_page_campaign', baseModel: 'vm-dynamic-condition' }, {
    /**
     * название условия
     */
    condition_name: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('b-dynamic-condition-edit', 'ukazhite-nazvanie', 'Укажите название')
                },
                maxLength: {
                    value: 100,
                    text: iget2('b-dynamic-condition-edit', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 100
                    }),
                    needToValidate: function(val) {
                        return !!val
                    }
                },
                hasOnlyAllowedSymbols: {
                    text: iget2(
                        'b-dynamic-condition-edit',
                        'v-pravilah-dopuskaetsya-ispolzovanie-uzbekskogo',
                        'В правилах допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского, узбекского алфавитов, цифр и знаков пунктуации'
                    ),
                    validate: function() {
                        return u.validation.isAllowedForBannerString(this.get('condition_name'));
                    }
                }
            }
        }
    },

    /**
     * список целей нацеливания
     */
    condition: {
        type: 'models-list',
        modelName: 'b-dynamic-goal-edit',
        validation: {
            rules: {
                required: {
                    validate: function() {
                        this.setGoalsUniqueField();

                        return this.get('condition').reduce(function(res, model) {
                            if (!model.isValid()) res = false;

                            return res;
                        }, true);
                    }
                }
            }
        }
    },

    /**
     * флаг, можно ли добавлять в список
     */
    canAdd: {
        type: 'boolean',
        dependsFrom: 'condition',
        internal: true,
        default: true,
        calculate: function() {
            return this.get('condition').length() < 10;
        }
    },

    /**
     * флаг, можно ли удалять из списка
     */
    canDelete: {
        type: 'boolean',
        dependsFrom: 'condition',
        internal: true,
        default: false,
        calculate: function() {
            return this.get('condition').length() > 1;
        }
    },

    /**
     * флаг, можно ли использовать условие по url списка предложений
     */
    canUseUrlProdlistType: {
        type: 'string',
        dependsFrom: 'condition',
        internal: true,
        default: 'both',
        calculate: function() {
            var uses = this.get('condition').reduce(function(res, el) {
                var kind = el.get('kind');

                if (el.get('type') === 'URL_prodlist') {
                    res.eq |= kind === 'equals';
                    res.dif |= kind === 'not_equals';
                }

                return res;
            }, { eq: false, dif: false });

            return uses.eq ?
                (uses.dif ? 'none' : 'not_equals') :
                (uses.dif ? 'equals' : 'both');
        }
    }
}, {
    /**
     * Обновляет флаг isUnique во вложенных моделях условий
     */
    setGoalsUniqueField: function() {
        var store = {};

        this.get('condition').forEach(function(model) {
            var str = model.getStateString(),
                isUsed = store[str];

            if (!isUsed) store[str] = true;

            model.set('isUnique', !isUsed);
        }, []);
    }
});
