block('b-dynamic-condition-edit')(

    def()(function() {
        return applyNext({
            controlMix: {
                block: 'b-dynamic-condition-edit',
                elem: 'goal-control'
            }
        });
    }),

    mix()(function() {
        return {
            block: 'i-controls-overseer',
            js: { of: this.controlMix }
        }
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-dynamic-condition-edit',
                id: this.ctx.condition ? this.ctx.condition.id : null
            },
            modelData: this.ctx.condition,
            isOneActiveConditionInGroup: this.ctx.isOneActiveConditionInGroup
        };
    }),

    elem('bid-controls').content()(function() {
        var condition = this.ctx.condition || {};

        return [
            !condition.strategy.name && !condition.strategy.is_autobudget && {
                elem: 'setting',
                elemMods: {
                    field: 'price',
                    single: 'yes'
                },
                fieldName: 'price',
                controlType: 'input',
                title: iget2('b-dynamic-condition-edit', 'cena-za-klik-s', 'Цена за клик, {foo}', {
                    foo: u.formatCurrency(this.ctx.currency)
                }),
                control: {
                    block: 'input',
                    mix: [{
                        block: 'b-dynamic-condition-edit',
                        elem: 'type',
                        elemMods: { type: 'input' }
                    }],
                    value: u.numberFormatter.format(condition.price),
                    mods: { clear: 'no' },
                    content: [
                        {
                            elem: 'control'
                        }
                    ]
                }
            },

            condition.strategy.name == 'different_places' && !condition.strategy.is_autobudget && {
                elem: 'prices',
                condition: condition,
                currency: this.ctx.currency
            }
        ];
    }),

    content()(function() {
        var condition = this.ctx.condition || {};

        return [
            {
                elem: 'title'
            },
            {
                elem: 'body',
                content: [
                    {
                        elem: 'setting',
                        elemMods: { field: u.beminize('condition_name') },
                        fieldName: 'condition_name',
                        controlType: 'input',
                        title: iget2('b-dynamic-condition-edit', 'nazvanie-usloviya', 'Название условия'),
                        control: {
                            block: 'input',
                            mix: [{
                                block: 'b-dynamic-condition-edit',
                                elem: 'type',
                                elemMods: { type: 'input' }
                            }],
                            value: condition.condition_name,
                            content: { elem: 'control' }
                        }
                    },
                    {
                        elem: 'bid-controls',
                        condition: condition,
                        currency: this.ctx.currency
                    },
                    {
                        block: 'composite',
                        mix: [
                            { block: 'b-dynamic-condition-edit', elem: 'goals' },
                            {
                                block: 'list-style',
                                mods: {
                                    theme: 'clean',
                                    numeration: 'yes',
                                    box: 'yes',
                                    deletion: 'icon'
                                }
                            }
                        ],
                        layout: {
                            block: 'b-dynamic-condition-edit',
                            elem: 'goals-list'
                        },
                        itemView: {
                            block: 'b-dynamic-condition-edit',
                            elem: 'goals-list-item',
                            controlMix: this.controlMix
                        }
                    }
                ]
            },
            {
                elem: 'controls',
                elemMods: {
                    readonly: this.mods.readonly
                },
                condition: condition
            }
        ];
    }),

    elem('prices').content()(function() {
        var condition = this.ctx.condition,
            strategy = condition.strategy;

        return [
            !strategy.is_search_stop && {
                elem: 'setting',
                elemMods: { field: 'price' },
                fieldName: 'price',
                controlType: 'input',
                title: iget2('b-dynamic-condition-edit', 'stavka-na-poiske-s', 'Ставка на поиске, {foo} ', {
                    foo: u.formatCurrency(this.ctx.currency)
                }),
                control: {
                    block: 'input',
                    mix: [{
                        block: 'b-dynamic-condition-edit',
                        elem: 'type',
                        elemMods: { type: 'input' }
                    }],
                    value: u.numberFormatter.format(condition.price),
                    mods: { clear: 'no' },
                    content: { elem: 'control' }
                }
            },
            {
                elem: 'setting',
                elemMods: { field: u.beminize('price_context') },
                fieldName: 'price_context',
                controlType: 'input',
                title: iget2('b-dynamic-condition-edit', 'stavka-na-tematich-ploshchadkah', 'Ставка на тематич. площадках, {foo} ', {
                    foo: u.formatCurrency(this.ctx.currency)
                }),
                control: {
                    block: 'input',
                    mix: [{
                        block: 'b-dynamic-condition-edit',
                        elem: 'type',
                        elemMods: { type: 'input' }
                    }],
                    value: u.numberFormatter.format(condition.price_context),
                    mods: { clear: 'no' },
                    content: { elem: 'control' }
                }
            }
        ];
    }),

    elem('setting-title').tag()('span'),

    elem('title')(
        tag()('h2'),
        content()(function() {
            return iget2('b-dynamic-condition-edit', 'nastroyka-usloviya-nacelivaniya', 'Настройка условия нацеливания');
        })
    ),

    elem('controls').content()(function() {
        return [
            {
                block: 'button',
                mods: { disabled: 'yes', theme: 'action' },
                mix: [
                    {
                        block: 'b-dynamic-condition-edit',
                        elem: 'save'
                    },
                    {
                        block: 'b-dynamic-condition-edit',
                        elem: 'model-field',
                        js: {
                            name: 'cantSave',
                            type: 'mod',
                            modName: 'disabled',
                            block: 'button'
                        }
                    }
                ],
                content: iget2('b-dynamic-condition-edit', 'sohranit', 'Сохранить')
            },
            {
                block: 'button',
                mix: {
                    block: 'b-dynamic-condition-edit',
                    elem: 'cancel'
                },
                content: iget2('b-dynamic-condition-edit', 'otmena', 'Отмена')
            }
        ];
    }),

    elem('setting').content()(function() {
        this.ctx.control.mix = this.ctx.control.mix || [];
        this.ctx.control.mix.push({
            block: 'b-dynamic-condition-edit',
            elem: 'model-field',
            js: {
                name: this.ctx.fieldName,
                type: this.ctx.controlType
            }
        });

        return [
            {
                elem: 'setting-title',
                content: this.ctx.title
            },
            {
                elem: 'control',
                content: this.ctx.control
            },
            { elem: 'error-message' }
        ];
    }),

    elem('goals-list').content()(function() {
        return [
            {
                block: 'composite',
                elem: 'items',
                mix: [
                    {
                        block: 'b-dynamic-condition-edit',
                        elem: 'goals-items'
                    },
                    {
                        block: 'list-style',
                        elem: 'items'
                    }
                ]
            },
            {
                block: 'b-control-add-button',
                mix: this.controlMix,
                content: iget2('b-dynamic-condition-edit', 'novoe-pravilo', 'Новое правило')
            },
            { elem: 'save-status-message' }
        ];
    }),

    elem('goals-list-item')(

        mix()(function() {
            return {
                block: 'list-style',
                elem: 'item'
            };
        }),

        content()(function() {
            return [
                {
                    elem: 'goals-list-item-separator',
                    content: iget2('b-dynamic-condition-edit', 'i', 'и')
                },
                {
                    block: 'b-dynamic-goal-edit',
                    parentId: this.ctx.parentId,
                    goal: this.ctx.itemData,
                    canUseUrlProdlistType: this.ctx.canUseUrlProdlistType
                },
                {
                    block: 'b-control-remove-button',
                    mods: {
                        icon: 'basket',
                        state: this.ctx.disableRemove ? 'disabled' : ''
                    },
                    data: { itemId: this.ctx.itemData.id },
                    mix: [
                        this.ctx.controlMix,
                        {
                            block: 'list-style',
                            elem: 'remove'
                        }
                    ]
                }
            ];
        })
    )
);
