BEM.DOM.decl({ block: 'b-dynamic-condition-edit', baseBlock: 'i-glue' }, {
    /**
     * Триггерит событие завершения редактирования.
     * @event condition:edit:completed
     * @type {object}
     * @property {number} id - id редактированнй модели
     * @property {object} modelData - обновленные данные модели
     */

    /**
     * Триггерит событие отмены редактирования.
     * @event condition:edit:canceled
     */

    /**
     * Слушает событие ошибки сохранения.
     * @event save:error
     * @type {object}
     * @property {object} e - объект события
     * @property {string} errText - текст ошибки
     */
    onSetMod: {
        js: function() {
            this.__base();

            u.graspSelf.call(this, {
                _addGoalBtn: 'b-control-add-button on goal-control',
                _saveBtn: 'button on save',
                _cancelBtn: 'button on cancel',
                _list: 'composite on goals'
            });

            // если нет условий нацеливания, добавляем 1
            !this.model.get('condition').length() && this._createGoalModel('both');

            this._addConditions(this.model.get('condition').map(function(item) {
                return item;
            }));

            this._initEvents();

            this.model.fix();
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._initCommonEvents();

        this._subscriptionManager.wrap(this.model)
            .on('condition condition_name price price_context', 'change', this._updateCannotSave, this)
            .on('fix', function() {
                this._updateCannotSave();
                this._toggleAddAbility(this.model.get('canAdd'));
                this._toggleRemoveAbility(this.model.get('canDelete'));
            }, this);
    },

    /**
     * Выполняет подписку на общие для страничных модификаторов события через i-subscription-manager
     * @private
     */
    _initCommonEvents: function() {

        this._subscriptionManager.wrap(this.findBlockOn('i-controls-overseer'))
            .on('add', function() {
                this.model.get('canAdd') && this._addConditions(
                    this._createGoalModel(this.model.get('canUseUrlProdlistType')));
            }, this)
            .on('remove', function(e, params) {
                if (this.model.get('canDelete')) {
                    this.model.get('condition').getById(params.data.itemId).destruct();
                    this._list.remove(params.data.itemId);
                }
            }, this);

        this._subscriptionManager.wrap(this.model)
            .on('canAdd', 'change', function(e, data) {
                this._toggleAddAbility(data.value);
            }, this)
            .on('canDelete', 'change', function(e, data) {
                this._toggleRemoveAbility(data.value);
            }, this)
            .on('validated', function(e, data) {
                this._clearErrors();
                !data.valid ?
                    this._showErrors(data) :
                    this.trigger('condition:edit:completed', {
                        id: this.model.id,
                        modelData: $.extend(this.model.toJSON(), {
                            goalsState: this.model.getGoalsState(),
                            dyn_id: this.model.id
                        })
                    });

            }, this);

        this._subscriptionManager.on(this._saveBtn, 'click', function() {
            this.model.validate();
        }, this);

        this._subscriptionManager.on(this._cancelBtn, 'click', function() {
            if (this.model.isChanged()) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-dynamic-condition-edit', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    onYes: function() {
                        this.trigger('condition:edit:canceled');
                    }.bind(this)
                });
            } else {
                this.trigger('condition:edit:canceled');
            }
        }, this);

        this._subscriptionManager.on(this, 'save:error', function(e, errText) {
            this._updateStatusMessage(errText);
        }, this);

        this._subscriptionManager.wrap(this._list)
            .on('add', function() {
                u.scrollNodeTo(this.findElem('goals-list-item').last(), this.elem('goals-items'));
            }, this);
    },

    /**
     * Обновляет состояние кнопки "Сохранить"
     */
    _updateCannotSave: function() {
        var condition = this.model.get('condition'),
            isEmpty,
            isChanged;

        if (!condition) {
            return false;
        }

        isEmpty = ['condition_name', 'price', 'price_context'].every(this.model.isEmpty.bind(this.model)) &&
            (!condition.length() || condition.some(function(goal) {
                return !goal.get('value').length;
            })),
            isChanged = ['condition_name', 'price', 'price_context', 'condition'].some(function(fieldName) {
                return this.model.fields[fieldName].isChanged();
            }, this);

        this.model.set('cantSave', !isChanged || isEmpty);
    },

    /**
     * Отображает статус сохранения условия
     * @param {String} errText - текст ошибки
     * @private
     */
    _updateStatusMessage: function(errText) {
        this.elem('save-status-message').text(errText);
    },

    /**
     * Снимает / устанавливает disabled модификатор с кнопки добавления цели
     * @param {Boolean} flag - флаг
     * @private
     */
    _toggleAddAbility: function(flag) {
        this._addGoalBtn.setMod('state', !flag ? 'disabled' : '');
    },

    /**
     * Снимает / устанавливает disabled модификатор с кнопок удаления цели
     * @param {Boolean} flag - флаг
     * @private
     */
    _toggleRemoveAbility: function(flag) {
        this.findBlocksOn('goal-control','b-control-remove-button').forEach(function(btn) {
            btn.setMod('state', !flag ? 'disabled' : '');
        }, this);
    },

    /**
     * Добавляет строку в список условий
     * @param {BEM.MODEL<b-dynamic-goal-edit>} data
     * @private
     */
    _addConditions: function(data) {
        var canUseUrlProdlistType = this.model.get('canUseUrlProdlistType'),
            parentId = this.model.id;

        this._list.add(data, {
            itemOptions: {
                disableRemove: data.length === 1,
                canUseUrlProdlistType: canUseUrlProdlistType,
                parentId: parentId
            }
        });
    },

    /**
     * Создает модель во вложенной коллекции condition
     * @param {String} canUseUrlProdlistType - флаг, можно ли использовать условие по url списка предложений
     * @returns {Object}
     * @private
     */
    _createGoalModel: function(canUseUrlProdlistType) {
        var type, kind;

        if (canUseUrlProdlistType === 'none') {
            type = 'URL';
            kind = 'exact';
        } else {
            type = 'URL_prodlist';
            kind = canUseUrlProdlistType === 'both' ? 'equals' : canUseUrlProdlistType;
        }

        return this.model.get('condition').add({
            type: type,
            kind: kind,
            value: [{ value: '', isUrl: type === 'URL_prodlist' }]
        }, { parentId: this.model.id });
    },

    /**
     * Удаляет блок и модель
     */
    destruct: function() {
        var goals = this.findBlocksInside('b-dynamic-goal-edit');

        goals.forEach(function(goalEdit) {
            goalEdit.unbindEvents();
        });

        goals.forEach(function(goalEdit) {
            goalEdit.destruct();
        });

        this._subscriptionManager.dispose();
        this.model.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Выводит текст ошибки data.text валидации на элементе elem и фокусируется на инпуте
     * @param {String} fieldName - имя поля с ошибкой
     * @param {Object} data - объект с данными об ошибке
     * @private
     */
    _showErrorOnElem: function(fieldName, data) {
        var elem = this.findElem('setting', 'field', u.beminize(fieldName)),
            block = this.findBlockInside(elem, 'input');

        block && block.setMod('focused', 'yes');
        this.setMod(elem, 'error', 'yes')
            .findElem(elem, 'error-message').text(data.text);
    },

    /**
     * Выводит ошибки на всех ошибочных полях
     * @param {Object} data - объект с данными об ошибке
     * @private
     */
    _showErrors: function(data) {
        data.errorFields.forEach(function(fieldName, i) {
            this._showErrorOnElem(fieldName, data.errors[i]);
        }, this);
    },

    /**
     * Очищает ошибки
     * @private
     */
    _clearErrors: function() {
        this.delMod(this.elem('setting'), 'error')
            .elem('error-message').empty();
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('add-value', 'b-dynamic-goal-edit', function(e, data) {
            u.scrollNodeTo(data.domElem, this.elem('goals-items'));
        });
    }

});
