block('b-dynamic-condition-row')(

    js()(function() {
        return !!this.data.view_only || this.data.archived === 'Yes' ?
            false :
            {
                currency: this.ctx.currency,
                modelId: this.ctx.condition.dyn_id,
                adgroupId: this.ctx.condition.adgroup_id
            };
    }),

    def()(function() {
        var cond = this.ctx.condition;

        return applyNext({
            condition: this.ctx.condition,
            isAnyCondition: cond.condition.length == 1 && cond.condition[0].type == 'any'
        });
    }),

    content()(function() {
        return this.isAnyCondition ?
            {
                elem: 'any-condition',
                content: iget2('b-dynamic-condition-row', 'vse-stranicy', 'Все страницы')
            } :
            [
                {
                    elem: 'content',
                    tag: 'span',
                    content: {
                        elem: 'condition-wrapper',
                        text: this.condition.condition_name
                    }
                },
                {
                    elem: 'edit-icon',
                    tag: 'img',
                    mix: {
                        block: 'b-icon',
                        mods: {
                            'size-16': 'edit'
                        }
                    }
                },
                {
                    block: 'b-dynamic-condition-summary',
                    mix: {
                        block: 'b-dynamic-condition-row',
                        elem: 'summary'
                    },
                    goals: this.condition.condition
                }
            ];
    })
);
