BEM.DOM.decl('b-dynamic-condition-row', {
    onSetMod: {
        js: function() {
            var dmDynamicConditionData;

            this.findBlockOutside('b-group-dynamic-condition'); //alkaline@todo проверить, нужно ли

            this.groupDM = BEM.MODEL.getOrCreate({ name: 'dm-dynamic-group', id: this.params.adgroupId });
            this.dmDynamicCondition = BEM.MODEL.getOrCreate({ name: 'dm-dynamic-condition', id: this.params.modelId });
            dmDynamicConditionData = this.dmDynamicCondition.toJSON();
            dmDynamicConditionData.condition.forEach(function(goal) {
                goal.value = u['b-dynamic-goal-edit-value'].makeValueArray(goal);
            });

            this.conditionModel = BEM.MODEL.create('b-dynamic-condition-row');

            this.conditionModel.update(
                u._.pick(dmDynamicConditionData, Object.keys(this.conditionModel.fieldsDecl))).fix();

            this.conditionModel.get('condition');

            this.dmDynamicCondition.on('fix', function() {
                this.delMod('changed');
            }, this);

            //из-за перестроения списка изменений происходит несколько, перерисовываемся только 1 раз
            this.conditionModel.on('change', $.debounce(this._onConditionChange, 0), this);
        }
    },

    /**
     * Приводит визуальное состояние в соответствии с измененным условием нацеливания
     */
    _onConditionChange: function() {
        this.setMod('changed', this.conditionModel.isChanged() ? 'yes' : 'no');

        BEM.DOM.replace(this.findElem('condition-wrapper'), BEMHTML.apply({
            block: 'b-dynamic-condition-row',
            elem: 'condition-wrapper',
            text: this.conditionModel.get('condition_name')
        }));

        BEM.DOM.replace(this.findElem('summary'), BEMHTML.apply({
            block: 'b-dynamic-condition-summary',
            mix: { block: 'b-dynamic-condition-row', elem: 'summary' },
            goals: this.conditionModel.toJSON().condition
        }));
    },

    /**
     * Показывает попап редактирования целей нацеливания
     * Подписывается на события блока b-dynamic-condition-edit
     *
     * @returns {BEM} this
     */
    showEditPopup: function() {
        var editBlock;

        this._popup = this._popup || this._getPopup();

        if (this._popup.isShown()) {
            return this;
        }

        editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        if (editBlock) {
            editBlock.destruct();
        }

        this._popup.setContent(BEMHTML.apply({
            block: 'b-dynamic-condition-edit',
            mods: { page: 'campaign', readonly: this.hasMod('editable', 'no') ? 'yes' : '' },
            condition: this.conditionModel.toJSON(),
            isOneActiveConditionInGroup: this.isOneActiveConditionInGroup()
        }));

        editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        editBlock
            .on('condition:edit:completed', this._onConditionEditComplete, this)
            .onFirst('condition:edit:canceled', this._hideEditPopup, this)
            .onFirst('condition:edit:deleted', this._onConditionDelete, this);

        //afterCurrentEvent нужен для того, чтобы не начал отрисовываться транзишн тумблера
        this.afterCurrentEvent(function() {
            this._popup.show(this.findElem('condition-wrapper'));
        });

        return this;
    },

    /**
     * Обновляет модели b-dynamic-condition-row и dm-dynamic-condition значениями пришедшими с попапа редактирования
     * Закрывает попап
     *
     * @param {Object} e событие завершения редактирования
     * @param {Object} data
     * @param {Object} data.modelData
     * @param {String} data.modelData.condition_name имя условия нацеливания
     * @param {Boolean} data.modelData.is_suspended если true условие выключено
     * @param {Boolean} data.modelData.is_deleted если true условие удалено
     * @param {Array} data.modelData.condition массив целей нацеливания vm-dynamic-goal
     *
     * @private
     */
    _onConditionEditComplete: function(e, data) {
        var modelData = data.modelData,
            editedFields = u._.pick(modelData, ['condition_name', 'is_suspended', 'is_deleted', 'condition']),
            isDuplicatedCondition = this._checkDuplicates(modelData),
            editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        if (isDuplicatedCondition) {
            this.conditionModel.update(editedFields);

            editedFields.condition.forEach(function(goal) {
                goal.value = u['b-dynamic-goal-edit-value'].convertValuesToStringArray(goal);
            });

            this.dmDynamicCondition.update(editedFields);

            this._hideEditPopup();
        } else {
            editBlock && editBlock.trigger(
                'save:error',
                iget2('b-dynamic-condition-row', 'uslovie-s-takim-sochetaniem', 'Условие с таким сочетанием правил уже существует в группе'));
        }
    },

    /**
     * Проверяет сохраняемую модель на совпадение с существующими
     * @param {Object} data - данные сохраняемой модели
     * @private
     */
    _checkDuplicates: function(data) {
        return this.groupDM.get('dynamic_conditions').every(function(condition) {
            var goalState = condition.getGoalsState();

            return (data.dyn_id !== condition.id) && (data.goalsState.length == goalState.length) ?
                !data.goalsState.every(function(draftSt) {
                    return goalState.indexOf(draftSt) >= 0;
                }) :
                true;
        });
    },

    /**
     * Выставляет поле is_deleted в true моделям b-dynamic-condition-row и dm-dynamic-condition
     * Закрывает попап редактирования
     *
     * @private
     */
    _onConditionDelete: function() {
        this.conditionModel.set('is_deleted', true);
        this.dmDynamicCondition.set('is_deleted', true);
        this._hideEditPopup();
    },

    /**
     * Проверяет является ли условие нацеливания последним активным в группе
     *
     * @returns {Boolean} если true то последнее активное
     */
    isOneActiveConditionInGroup: function() {
        var group = BEM.MODEL.getOrCreate({ name: 'dm-dynamic-group', id: this.params.adgroupId }),
            conditions = group.get('dynamic_conditions');

        return conditions.filter(function(conditionModel) {
            return !conditionModel.get('is_deleted') && !conditionModel.get('is_suspended');
        }).length <= 1;
    },

    /**
     * Возвращает инстанс поп-апа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance(
            { size: 'xs', animate: 'no', autoclosable: false, 'content-adaptive': 'yes', 'has-close': 'yes' },
            {
                directions: [
                    'right-middle-middle',
                    { to: 'bottom', axis: 'left', offset: { right: 150 } },
                    { to: 'top', axis: 'left', offset: { right: 150 } }
                ]
            },
            { content: { block: 'b-dynamic-condition-row', elem: 'popup-content' } });
    },

    /**
     * Скрывает поп-ап
     * @returns {BEM}
     * @private
     */
    _hideEditPopup: function() {
        this._popup.hide();

        return this;
    }
}, {
    live: function() {
        this
            .liveBindTo('content', 'touchstart click', function() {
                if (this.hasMod('editable', 'yes') || this.hasMod('clickable', 'yes')) {
                    this.showEditPopup();
                }
            });
    }
});
