BEM.DOM.decl({ block: 'b-dynamic-condition2', modName: 'type', modVal: 'any' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this.DM = BEM.MODEL.getOrCreate({ name: 'dm-dynamic-condition', id: this.params.modelParams.id });

            this.model
                .on('price price_context', 'change', function(e, data) {
                    this.model.isChanged() && this.model.validate();
                }, this)
                .on('validated', function(e, data) {
                    this.DM.update({
                        price: this.model.get('price'),
                        price_context: this.model.get('price_context')
                    });
                    data.valid ? this._clearErrors() : this._showErrors(data)
                }, this);

            this.model.on('destruct', this.destruct, this);
        }
    },

    /**
     * Выводит текст ошибки data.text валидации на элементе elem и фокусируется на инпуте
     * @param {String} fieldName - имя поля с ошибкой
     * @param {Object} data - объект с данными об ошибке
     * @private
     */
    _showErrorOnElem: function(fieldName, data) {
        var elem = this.findElem('setting', 'field', fieldName),
            block = this.findBlockInside(elem, 'input');

        block && block.setMod('focused', 'yes');
        this.setMod(elem, 'error', 'yes')
            .findElem(elem, 'error-message').text(data.text);
    },

    /**
     * Выводит ошибки на всех ошибочных полях
     * @param {Object} data - объект с данными об ошибке
     * @private
     */
    _showErrors: function(data) {
        data.errorFields.forEach(function(fieldName, i) {
            this._showErrorOnElem(fieldName, data.errors[i]);
        }, this);
    },

    /**
     * Очищает ошибки
     * @private
     */
    _clearErrors: function() {
        this.delMod(this.findElem('setting'), 'error')
            .elem('error-message').empty();
    }
});
