block('b-dynamic-condition2').mod('type', 'detailed')(

    content()(function() {
        return [
            {
                elem: 'condition-name',
                name: this.ctx.condition.condition_name
            },
            {
                block: 'button',
                mods: {
                    size: 'xs',
                    theme: 'normal'
                },
                mix: {
                    block: 'b-dynamic-condition2',
                    elem: 'edit-condition'
                },
                content: iget2('b-dynamic-condition2', 'izmenit', 'изменить')
            },
            {
                elem: 'goals-summary',
                content: u._.compact([
                    !this.ctx.strategy.name && !this.ctx.strategy.is_autobudget && {
                        elem: 'price',
                        content: [
                            {
                                elem: 'price-text',
                                content: [
                                    iget2('b-dynamic-condition2', 'bid-currency', 'Cтавкa, {foo} ', {
                                        foo: this.ctx.currency
                                    }),
                                    {
                                        elem: 'price-value',
                                        content: u.numberFormatter.format(this.ctx.condition.price)
                                    }
                                ]
                            }
                        ]
                    },
                    this.ctx.strategy.name == 'different_places' && [
                        !this.ctx.strategy.is_search_stop && {
                            elem: 'price',
                            content: [
                                {
                                    elem: 'price-text',
                                    content: [
                                        iget2('b-dynamic-condition2', 'stavka-na-poiske-s', 'Cтавкa на поиске, {foo} ', {
                                            foo: this.ctx.currency
                                        }),
                                        {
                                            elem: 'price-value',
                                            content: u.numberFormatter.format(this.ctx.condition.price)
                                        }
                                    ]
                                }
                            ]
                        },
                        !this.ctx.strategy.is_autobudget && (
                            {
                                elem: 'price',
                                content: [
                                    {
                                        elem: 'price-text',
                                        content: [
                                            iget2('b-dynamic-condition2', 'stavka-na-tematich-ploshchadkah', 'Ставка на тематич. площадках, {foo} ', {
                                                foo: this.ctx.currency
                                            }),
                                            {
                                                elem: 'price-value',
                                                content: u.numberFormatter.format(this.ctx.condition.price_context)
                                            }
                                        ]
                                    }
                                ]
                            }
                        )
                    ],

                    {
                        elem: 'summary-text',
                        content: u.hellipCut(this.ctx.summary, 80)
                    }
                ])
            }
        ];
    })
);
