block('b-dynamic-condition2')(

    js()(function() {
        return {
            modelParams: {
                name: 'b-dynamic-condition2',
                parentName: 'b-dynamic-conditions2',
                parentId: this.ctx.groupId,
                id: this.ctx.condition.dyn_id
            }
        };
    }),

    elem('condition-name')(
        tag()('b'),
        content()(function() {
            return this.ctx.name ? u.escapeHTML(u.hellipCut(this.ctx.name, 30, '...')) : iget2('b-dynamic-condition2', 'bezymyannoe-uslovie', 'Безымянное условие');
        })
    ),

    elem('prices').content()(function() {
        return this.ctx.prices.map(function(price) {
            return {
                elem: 'price',
                content: [
                    {
                        elem: 'price-text',
                        content: [
                            price.title + ', ' + u.formatCurrency(this.ctx.currency) + ': ',
                            {
                                elem: 'price-value',
                                content: price.value
                            }
                        ]
                    }
                ]
            };
        }, this);
    }),

    elem('setting').content()(function() {
        this.ctx.control.mix = this.ctx.control.mix || [];

        this.ctx.control.mix.push({
            block: 'b-dynamic-condition2',
            elem: 'model-field',
            js: {
                name: this.ctx.fieldName,
                type: this.ctx.controlType
            }
        });

        return [
            {
                elem: 'setting-title',
                elemMods: { name: this.ctx.fieldName },
                content: this.ctx.title
            },
            {
                elem: 'control',
                mix: { name: this.ctx.fieldName },
                content: this.ctx.control
            },
            {
                elem: 'error-message'
            }
        ];
    })
);
