BEM.MODEL.decl({ name: 'b-dynamic-condition2', baseModel: 'vm-dynamic-condition-bidable' }, {
    /**
     * список условий нацеливания
     */
    condition: {
        type: 'models-list',
        modelName: 'b-dynamic-goal'
    },

    /**
     * суммарная строка по всем условиям
     */
    conditionSummary: {
        internal: true,
        dependsFrom: 'condition',
        calculate: function() {
            return this.get('condition').map(function(item) {
                return item.get('summary');
            }, this).join(', ');
        }
    },

    isDefaultGoal: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            return this.get('condition').every(function(goal) {
                return goal.get('type') == 'any';
            })
        }
    }

});
