block('b-dynamic-conditions-group')(
    def()(function() {
        var ctx = this.ctx,
            group = ctx.group,
            header = [],
            campaignIsArchived = this.data.archived === 'Yes';

        if (!this.data.view_only && !campaignIsArchived && ctx.dynamicConditions.length &&
            (ctx.state != 'active' || group.editable_price) && !ctx.isConditionIsOfTypeAny) {

            header = [
                {
                    block: 'b-dynamic-conditions-group',
                    elem: 'input-block',
                    conditions: ctx.dynamicConditions,
                    elemMods: {
                        state: ctx.state
                    },
                    group: group,
                    colsNum: ctx.colsNum,
                    platform: ctx.platform
                }
            ];
        }

        !ctx.dynamicConditions.length && ctx.state == 'active' && header.unshift({
            block: 'b-dynamic-conditions-group',
            elem: 'empty-block',
            colsNum: ctx.colsNum,
            mix: [{
                block: 'b-style-table',
                elem: 'row'
            }],
            group: group
        });

        return applyNext({
            header: header
        });
    }),

    addJs()(function() {
        return {
            state: this.ctx.state,
            platform: this.ctx.platform
        };
    }),

    content()(function() {
        var res = [],
            ctx = this.ctx,
            group = ctx.group,
            banner = ctx.banner,
            state = ctx.state,
            platform = ctx.platform,
            dynamicConditions = ctx.dynamicConditions || [],
            isAutobudget = this.data.campaign.strategy.is_autobudget,
            colsNum = ctx.colsNum,
            groupedConditions = u._.groupBy(dynamicConditions, function(item) {
                return item.is_suspended ? 'suspended' : 'active';
            });

        this.header && res.push(this.header);

        (groupedConditions['active'] || []).forEach(function(condition, i) {
            res.push({
                block: 'b-group-dynamic-condition',
                mods: {
                    first: i == 0 ? 'yes' : ''
                },
                mix: [{
                    block: 'b-dynamic-conditions-group',
                    elem: 'conditions',
                    elemMods: {
                        platform: platform
                    }
                }],
                isFirst: i == 0,
                colsNum: colsNum,
                condition: condition,
                readonly: group.archive === 'Yes',
                group: group,
                banner: banner,
                state: state,
                platform: platform,
                isAutobudget: isAutobudget,
                isConditionIsOfTypeAny: ctx.isConditionIsOfTypeAny
            });
        });

        if (groupedConditions['suspended'] && groupedConditions['suspended'].length) {
            res.push({
                block: 'b-dynamic-conditions-group',
                elem: 'input-block',
                conditions: ctx.dynamicConditions,
                elemMods: {
                    state: 'inactive'
                },
                group: group,
                colsNum: ctx.colsNum,
                platform: ctx.platform
            });

            groupedConditions['suspended'].forEach(function(condition, i) {
                res.push({
                    block: 'b-group-dynamic-condition',
                    mods: {
                        first: i == 0 ? 'yes' : '',
                        'is-suspended': 'yes'
                    },
                    mix: [{
                        block: 'b-dynamic-conditions-group',
                        elem: 'conditions',
                        elemMods: {
                            inactive: 'yes',
                            platform: platform
                        }
                    }],
                    isFirst: i == 0,
                    colsNum: colsNum,
                    condition: condition,
                    readonly: group.archive === 'Yes',
                    group: group,
                    banner: banner,
                    state: state,
                    platform: platform,
                    isAutobudget: isAutobudget,
                    isConditionIsOfTypeAny: ctx.isConditionIsOfTypeAny
                });
            });
        }

        return res;
    })
);

block('b-dynamic-conditions-group').elem('empty-block').content()(function() {
    return {
        block: 'b-dynamic-conditions-group',
        elem: 'empty-block-text',
        attrs: {
            colspan: this.ctx.colsNum
        },
        mix: {
            block: 'b-style-table',
            elem: 'cell',
            elemMods: {
                first: 'yes'
            }
        }
    };
});

block('b-dynamic-conditions-group').elem('input-block').elemMod('state', 'context')(
    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),
    content()(function() {
        var isAutobudget = this.data.campaign.strategy.is_autobudget,
            isContext = this.ctx.platform == 'context',
            tail = [];

        tail.push({
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: (this.ctx.group.editable_price && this.ctx.platform != 'search') ?
                {
                    elem: 'edit-price',
                    contextOnly: 1,
                    group: this.ctx.group,
                    elemMods: {
                        platform: this.ctx.platform
                    },
                    platform: this.ctx.platform,
                    state: this.elemMods.state
                } :
                { elem: 'empty' }
        });

        //заглушка для min-price (нет на контексте в отдельном размещении)
        !isContext && !isAutobudget && tail.push({
            block: 'b-dynamic-conditions-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        //заглушка для колонки "действующая ставка"
        isAutobudget && tail.push({
            block: 'b-dynamic-conditions-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        return [
            {
                elem: 'subheader-context',
                block: 'b-dynamic-conditions-group',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                }],
                attrs: {
                    colspan: this.ctx.colsNum - tail.length
                },
                content: [
                    {
                        elem: 'subheader',
                        content: iget2('b-dynamic-conditions-group', 'tolko-v-setyah', 'Только в сетях')
                    },
                    this.ctx.group.editable_price && this.platform != 'search' && {
                        elem: 'edit-all-prices',
                        content: iget2('b-dynamic-conditions-group', 'dlya-vseh-usloviy-na', 'Для всех условий на площадках:')
                    }
                ]
            },
            tail
        ];
    })
);

block('b-dynamic-conditions-group').elem('input-block').elemMod('state', 'inactive')(
    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),
    content()(function() {
        return {
            block: 'b-dynamic-conditions-group',
            elem: 'subheader-inactive',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: { first: 'yes' }
            }],
            attrs: {
                colspan: this.ctx.colsNum
            },
            content: {
                block: 'button',
                mods: {
                    arrow: 'down',
                    pseudo: 'yes'
                },
                mix: [{
                    block: 'b-dynamic-conditions-group',
                    elem: 'inactive-toggle-button'
                }],
                content: [
                    {
                        block: 'b-dynamic-conditions-group',
                        elem: 'inactive-toggler',
                        elemMods: {
                            mode: 'hide'
                        },
                        content: iget2('b-dynamic-conditions-group', 'skryt-otklyuchennye', 'Скрыть отключенные')
                    },
                    {
                        block: 'b-dynamic-conditions-group',
                        elem: 'inactive-toggler',
                        elemMods: {
                            mode: 'show'
                        },
                        content: iget2('b-dynamic-conditions-group', 'pokazat-otklyuchennye', 'Показать отключенные')
                    }
                ]
            }
        };
    })
);

block('b-dynamic-conditions-group').elem('input-block').elemMod('state', 'active')(

    addMix()([{
        block: 'b-style-table',
        elem: 'row',
        elemMods: {
            hlt: 'default',
            type: 'border'
        }
    }]),

    content()(function() {
        var res = [],
            ctx = this.ctx,
            platform = ctx.platform,
            tail = [];

        tail.push({
            elem: 'cell',
            block: 'b-dynamic-conditions-group',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: {
                block: 'b-dynamic-conditions-group',
                elem: 'edit-price',
                elemMods: {
                    platform: platform
                },
                group: ctx.group,
                platform: platform,
                state: this.elemMods.state
            }
        });

        res.push({
            elem: 'cell',
            block: 'b-dynamic-conditions-group',
            attrs: {
                colspan: ctx.colsNum - tail.length
            },
            mix: [
                {
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: {
                        valign: 'middle',
                        align: 'right'
                    }
                },
                {
                    block: 'b-dynamic-conditions-group',
                    elem: 'subheader-active'
                }
            ],
            content: {
                block: 'b-dynamic-conditions-group',
                elem: 'edit-all-prices',
                content: (platform == 'context' ?
                    iget2('b-dynamic-conditions-group', 'dlya-vseh-usloviy-v', 'Для всех условий в сетях:') :
                    // если у нас отдельное размещение на поиске
                    // либо есть фразы активные только на контексте
                    platform == 'search' || ctx.group.sorted.dynamicConditions.context.length != 0 ?
                    iget2('b-dynamic-conditions-group', 'dlya-vseh-usloviy-na-104', 'Для всех условий на поиске:') :
                    iget2('b-dynamic-conditions-group', 'dlya-vseh-usloviy', 'Для всех условий:'))
            }
        });

        return res.concat(tail);
    })
);

block('b-dynamic-conditions-group').elem('edit-price').content()(function() {
    var ctx = this.ctx,
        group = ctx.group,
        platform = ctx.platform,
        isAutobudget = this.data.campaign.strategy.is_autobudget,
        elemMod = platform == 'search' ?
            'search' :
            platform == 'context' && !isAutobudget ? 'context' :
            group.editable_price && isAutobudget ?
            'autobudget' :
            !ctx.contextOnly ? 'search' : 'context';

    if (elemMod === 'autobudget') {
        return '';
    }

    return {
        block: 'b-edit-phrase-price',
        mods: {
            'control-type': elemMod,
            multiedit: 'yes'
        },
        mix: {
            block: 'b-dynamic-conditions-group',
            elem: 'price-control'
        },
        campDMParams: {
            id: this.data.campaign.cid,
            name: u.campaign.getCampaignModelName(this.data.campaign.mediaType)
        },
        group: group,
        editable: 1
    };
});
