/**
 * Группа условий нацеливания (из списка условий нацеливания на странице кампании)
 */
BEM.DOM.decl({ block: 'b-dynamic-conditions-group', implements: 'i-sortable-interface' }, {

    onSetMod: {

        js: function() {
            this.initModels();
            this._initGroupControls();
        }

    },

    /**
     * Инициализирует групповые контроллы для данной группы (используется b-dynamic-conditions-table)
     * @returns {BEM}
     */
    _initGroupControls: function() {
        if (this.inited) return this;

        this.size = this.getConditions().length;

        this.findBlocksInside('input-block', 'b-edit-phrase-price').forEach(function(control) {
            control.initModels(this.getModels());
        }, this);

        this.inited = true;

        return this;
    },

    /**
     * Возвращает родительский список фраз
     * @returns {BEM}
     */
    getParent: function() {
        return this.parent || (this.parent = this.findBlockOutside('b-dynamic-conditions-table'));
    },

    /**
     * Возвращает BEM-Блоки для фраз, содержащихся в данной группе
     * @returns {Object}
     */
    getConditions: function() {
        return this.conditions ||
            (this.conditions = this.findBlocksInside('b-group-dynamic-condition').filter(function(condition) {
                return condition.getMod('deleted') != 'yes';
            }));
    },

    /**
     * Инициализируем модели для данной группы
     * @returns {BEM}
     */
    initModels: function() {
        if (this.models) return this;

        var conditions = this.getConditions();

        this.models = Object.keys(conditions).map(function(key) {
            return this.conditions[key].getModel();
        }, this);

        this.models.forEach(function(model) {
            model && BEM.MODEL.on({
                name: model.name,
                id: model.get('dyn_id')
            }, 'destruct', this.onModelDestruct, this);
        }, this);

        return this;
    },

    /**
     * Какая-то из моделей группы была удалена
     * @returns {BEM}
     */
    onModelDestruct: function() {
        var size = this.size - 1;

        this.setMod('empty', size == 0 ? 'yes' : 'no');

        return this;
    },

    /**
     * Сортирует набор блоков elements по полю fieldName
     * @param {Array} elements
     * @param {String} fieldName
     * @param {Boolean} reverse - обратный/прямой вид сортировки
     * @returns {Object}
     */
    getSortedFragment: function(elements, fieldName, reverse) {
        reverse = reverse ? -1 : 1;

        var domElem,
            _this = this,
            platform = this.params.platform,
            fragment = document.createDocumentFragment(),
            sorted = elements.sort(function(a, b) {
                var sortTr,
                    valA = a.getModel().get(fieldName),
                    valB = b.getModel().get(fieldName);

                if (fieldName == 'condition_name') {
                    valA = valA.toLowerCase();
                    valB = valB.toLowerCase();
                }

                //для турции своя лексикографическая сортировка
                if (u.consts('locale') == 'tr' && fieldName == 'condition_name') {
                    sortTr = u.sortTr(valA, valB);
                    return reverse * sortTr;
                } else {
                    if (valA < valB) {
                        return -reverse;
                    } else if (valA > valB) {
                        return reverse;
                    }
                }

                return 0;
            });

        sorted.forEach(function(block, i) {
            if (block.domElem.length > 1) {
                domElem = block.domElem.filter(function(i, blockPart) {
                    return _this.getMod($(blockPart), 'platform') == platform;
                });
            } else {
                domElem = block.domElem;
            }
            block.setMod(domElem, 'first', i == 0 ? 'yes' : '');

            fragment.appendChild(domElem.get(0));
        }, this);

        return fragment;
    },

    /**
     * Возвращает массив моделей соответствующих фразам данной группы
     * @returns {BEM.MODEL[]}
     */
    getModels: function() {
        this.initModels();

        return this.models;
    },

    /**
     * Проверяет, проинициализированны ли фразы и контролы для данной группы
     * @returns {Boolean}
     */
    isControlsInited: function() {
        return this._controlsInited;
    },

    /**
     * Устанавливает флаг _controlsInited в положение true
     * @returns {BEM}
     */
    setControlsInited: function() {
        this._controlsInited = true;

        return this;
    },

    /**
     * Сортирует элементы внутри данной группы
     * @param {String} sortField
     * @param {Boolean} toMin
     * @returns {BEM}
     */
    sort: function(sortField, toMin) {
        this.initModels();

        this._itemBlocks = this._itemBlocks || this.findBlocksInside('b-group-dynamic-condition');

        var fragment = this.getSortedFragment(this._itemBlocks, sortField, toMin);

        this.elem('condition').remove();
        this.domElem.append(fragment);

        return this;
    },

    toggle: function(e) {
        this.setMod('hide-inactive', this.getMod('hide-inactive') == 'no' ? 'yes' : 'no');
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init', 'b-edit-phrase-price')
            .liveBindTo('inactive-toggle-button', 'click', function(e) {
                var button = this.findBlockOn(e.data.domElem, 'button');

                if (button) {
                    button.toggleMod('arrow', 'down', 'up');

                    button.isDisabled() || this.toggle();
                }
            });
    }
});
