block('b-dynamic-conditions-table')(
    def()(function() {
        var data = this.data,
            group = this.ctx.group,
            platform = this.mods.platform,
            contents = [{
                block: 'b-dynamic-conditions-table',
                elem: 'header',
                mix: [{
                    block: 'b-style-table',
                    elem: 'head'
                }],
                group: group,
                platform: platform
            }],
            colsNum,
            dynamicConditionsCount = 0,
            campaignIsArchived = data.archived === 'Yes';

        data.showStat = data.OrderID !== '0' && !campaignIsArchived;

        //фраза + ставка
        colsNum = 2;

        if (data.showStat) {
            colsNum += (platform == 'context') ?
                //на контексте статистика только по кликам
                1 :
                //на поиске три столбца со статистикой
                3;
        }

        // для архивных кампаний дополнительный столбец со ссылкой на мастер отчетов
        if (campaignIsArchived) {
            colsNum++;
        }

        var groupNames = data.campaign.strategy_name == 'different_places' && platform == 'search' ?
            ['active'] :
            ['active', 'context'];

        this.isConditionIsOfTypeAny = false;

        groupNames.forEach(function(name) {
            var dynamicConditions = group.sorted.dynamicConditions[name],
                size = dynamicConditions.length,
                inactive = name == 'suspended' ? 'yes' : 'no',
                state = u.beminize(name),
                condition = dynamicConditions.length && dynamicConditions[0].condition,
                // группа - это условие нацеливания "Все страницы"
                isConditionIsOfTypeAny = condition && condition.length == 1 && condition[0].type === 'any';

            if (isConditionIsOfTypeAny) {
                this.isConditionIsOfTypeAny = true;
            }

            (dynamicConditions.length || name == 'active') && contents.push({
                block: 'b-dynamic-conditions-group',
                mods: {
                    state: state,
                    inactive: inactive,
                    adgroupId: group.adgroup_id,
                    empty: size == 0 ? 'yes' : 'no',
                    platform: platform,
                    'hide-inactive': 'yes'
                },
                showStat: data.showStat,
                inactive: inactive,
                state: state,
                dynamicConditions: dynamicConditions,
                isConditionIsOfTypeAny: isConditionIsOfTypeAny,
                colsNum: colsNum,
                group: group,
                platform: platform,
                autobudget: group.autobudget
            });

            dynamicConditionsCount += dynamicConditions.length;
        }, this);

        this.ctx.mods = this.extend(this.ctx.mods || {}, {
            'group-id': group.adgroup_id
        });

        return applyNext({
            contents: contents,
            showStat: data.showStat,
            dynamicConditionsCount: dynamicConditionsCount,
            colsNum: colsNum
        });
    }),

    addJs()(true),

    content()(function() {
        return [
            this.data.campaign.platform == 'both' && {
                elem: 'title',
                content: this.mods.platform == 'search' ? iget2('b-dynamic-conditions-table', 'na-poiske', 'На поиске') : iget2('b-dynamic-conditions-table', 'v-setyah', 'В сетях')
            },
            {
                block: 'b-dynamic-conditions-table',
                elem: 'paranja'
            },
            {
                block: 'b-dynamic-conditions-table',
                elem: 'table',
                mix: [
                    {
                        block: 'b-phrases-list-sort',
                        js: true
                    },
                    {
                        block: 'b-style-table',
                        mods: {
                            theme: 'bordered'
                        }
                    },
                    this.data.campaign.platform == 'both' && {
                        block: 'b-dynamic-conditions-table',
                        elem: '3-em-margin'
                    }
                ],
                content: this.contents
            }
        ];
    })
);

block('b-dynamic-conditions-table').elem('paranja').content()({
    block: 'spinner'
});

block('b-dynamic-conditions-table').elem('header').content()(function() {
    var data = this.data,
        isContext = this.ctx.platform == 'context',
        isAutobudget = data.campaign.strategy.is_autobudget,
        topHeader = [],
        formatedCurrency = u.currencies.getName(data.campaign.currency),
        //cyn@ не используемая переменная, решил оставить может где потеряли
        // help = {
        //     block: 'b-help-link',
        //     url: u.getHelpUrl('positions'),
        //     mods: {
        //         align: 'top'
        //     }
        // },
        groupMultiplierStats = this.ctx.group.group_multiplier_stats || {},
        adjustmentsLowerBound = groupMultiplierStats.adjustments_lower_bound,
        adjustmentsUpperBound = groupMultiplierStats.adjustments_upper_bound,
        campaignIsArchived = data.archived === 'Yes',
        hasAdjustmentFork = !campaignIsArchived &&
            (typeof adjustmentsUpperBound == 'number' || typeof adjustmentsLowerBound == 'number'),
        emptyCols = [];

    topHeader = [
        {
            block: 'b-dynamic-conditions-table',
            elem: 'header-cell',
            autobudget: this.data.autobudget,
            elemMods: {
                content: 'phrase',
                'for-condition-type': this.isConditionIsOfTypeAny ? 'any' : ''
            },
            attrs: {
                rowspan: '1',
                colspan: campaignIsArchived ? '2' : '1'
            },
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: { first: 'yes' }
            }],
            content: this.dynamicConditionsCount > 1 ?
                {
                    block: 'b-phrases-list-sort',
                    elem: 'sort-link',
                    elemMods: {
                        name: 'condition-name',
                        sort: 'up'
                    },
                    title: iget2('b-dynamic-conditions-table', 'uslovie-nacelivaniya', 'Условие нацеливания')
                } :
                {
                    elem: 'header-title',
                    content: iget2('b-dynamic-conditions-table', 'uslovie-nacelivaniya', 'Условие нацеливания')
                }
        }
    ];

    if (this.showStat) {
        var i,
            statFields = isContext ?
                { 'ctx-clicks': iget2('b-dynamic-conditions-table', 'kliki', 'Клики') } :
                ({
                    shows: iget2('b-dynamic-conditions-table', 'pokazy', 'Показы'),
                    clicks: iget2('b-dynamic-conditions-table', 'kliki', 'Клики'),
                    ctr: iget2('b-dynamic-conditions-table', 'ctr', 'CTR')
                });

        for (i in statFields) {
            topHeader.push({
                block: 'b-dynamic-conditions-table',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }],
                elem: 'header-cell',
                autobudget: isAutobudget,
                elemMods: {
                    'for-condition-type': this.isConditionIsOfTypeAny ? 'any' : '',
                    content: 'stat'
                },
                attrs: {
                    rowspan: '1'
                },
                content: {
                    block: 'b-phrases-list-sort',
                    elem: 'sort-link',
                    elemMods: {
                        name: i
                    },
                    title: statFields[i]
                }
            });
        }
    }

    topHeader.push({
        block: 'b-dynamic-conditions-table',
        mix: [{
            block: 'b-style-table',
            elem: 'cell',
            elemMods: { align: 'center' }
        }],
        elem: 'header-cell',
        attrs: {
            colspan: '1',
            rowspan: '1'
        },
        elemMods: {
            'for-condition-type': this.isConditionIsOfTypeAny ? 'any' : '',
            content: 'price'
        },
        content: isAutobudget ?
            '' :
            iget2('b-dynamic-conditions-table', 'bid-header', 'Ставка, {foo}', {
                foo: formatedCurrency
            })
    });

        // DIRECT-43188
    if (hasAdjustmentFork) {
        for (i = 1; i < this.colsNum; i++) {
            emptyCols.push({
                block: 'b-dynamic-conditions-table',
                mix: [
                    {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    {
                        block: 'b-phrases-list',
                        elem: 'header-cell'
                    }
                ],
                elem: 'header-cell'
            });
        }
    }

    return [
        {
            block: 'b-dynamic-conditions-table',
            elem: 'header-row',
            mix: [{
                block: 'b-style-table',
                elem: 'row',
                elemMods: {
                    position: 'top'
                }
            }],
            content: topHeader
        },
        hasAdjustmentFork && {
            block: 'b-dynamic-conditions-table',
            elem: 'header-row',
            mix: [{
                block: 'b-style-table',
                elem: 'row',
                elemMods: {
                    position: 'bottom'
                }
            }],
            content: [
                {
                    block: 'b-dynamic-conditions-table',
                    mix: {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    elem: 'header-cell',
                    content: {
                        block: 'b-adjustment-rates-fork',
                        lowerBound: adjustmentsLowerBound,
                        upperBound: adjustmentsUpperBound
                    }
                },
                emptyCols
            ]
        }
    ];
});
