block('b-dynamic-conditions2')(

    def()(function() {
        return applyNext({
            groupId: this.ctx.groupId,
            currency: this.ctx.currency,
            strategy: this.ctx.strategy,
            conditionsType: this.ctx.type
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-dynamic-conditions2',
                id: this.groupId
            },
            currency: this.currency,
            strategy: this.strategy
        };
    }),

    elem('add')(
        tag()('span'),
        content()(function() {
            return {
                block: 'link',
                mix: {
                    block: 'b-dynamic-conditions2',
                    elem: 'add-link'
                },
                mods: {
                    pseudo: 'yes',
                    inner: 'yes'
                },
                content: [
                    {
                        block: 'b-icon',
                        mods: { 'size-13': 'plus-sign' },
                        mix: {
                            block: 'b-dynamic-conditions2',
                            elem: 'add-icon'
                        }
                    },
                    {
                        elem: 'inner',
                        mix: {
                            block: 'b-dynamic-conditions2',
                            elem: 'add-text'
                        },
                        content: iget2('b-dynamic-conditions2', 'novoe-uslovie', 'Новое условие')
                    }
                ]
            };
        })
    ),

    elem('type-chooser').content()(function() {
        return {
            block: 'radio-button',
            name: 'dynamic-conditions-type',
            value: this.ctx.type,
            content: [
                {
                    elem: 'radio',
                    controlAttrs: { value: 'any' },
                    content: iget2('b-dynamic-conditions2', 'vse-stranicy-sayta', 'Все страницы сайта')
                },
                {
                    elem: 'radio',
                    controlAttrs: { value: 'detailed' },
                    content: iget2('b-dynamic-conditions2', 'gruppa-stranic', 'Группа страниц')
                }
            ]
        };
    }),

    elem('list')(
        tag()('ol'),
        js()(true)
    ),

    elem('message').tag()('span'),

    elem('list-item')(
        tag()('li'),

        content()(function() {
            return [
                {
                    block: 'b-dynamic-condition2',
                    mods: { type: this.ctx.type },
                    groupId: this.ctx.groupId,
                    condition: this.ctx.condition,
                    currency: u.currencies.getName(this.ctx.currency),
                    strategy: this.ctx.strategy,
                    summary: this.ctx.condition.condition.map(function(goal) {
                        return u.dynamicGroupsData.getSummaryText(goal);
                    }).join(', ')
                },
                {
                    block: 'button',
                    mods: { theme: 'plain' },
                    mix: {
                        block: 'b-dynamic-conditions2',
                        elem: 'delete-condition'
                    },
                    content: {
                        block: 'b-icon',
                        mods: { 'size-13': 'grey-cross' }
                    }
                }
            ];
        })),

    content()(function() {
        return [
            {
                elem: 'type-chooser',
                type: this.ctx.type
            },
            {
                elem: 'list',
                content: this.ctx.conditions && this.ctx.conditions.map(function(condition) {
                    return {
                        elem: 'list-item',
                        js: { modelId: condition.dyn_id },
                        type: this.ctx.type,
                        groupId: this.ctx.groupId,
                        condition: condition,
                        strategy: this.strategy,
                        currency: this.currency
                    };
                }, this)
            },
            {
                elem: 'add'
            },
            {
                elem: 'add-disabled-hint',
                mix: {
                    elem: 'model-field',
                    elemMods: { visible: (this.ctx.conditions || []).length < 50 ? '' : 'yes' },
                    js: {
                        name: 'isAddDisabled',
                        type: 'mod',
                        modName: 'visible',
                        block: 'b-dynamic-conditions2',
                        elem: 'add-disabled-hint'
                    }
                },
                content: iget2(
                    'b-dynamic-conditions2',
                    'dostignuto-maksimalnoe-kolichestvo-usloviy',
                    'Достигнуто максимальное количество условий нацеливания на группу'
                )
            }
        ];
    })
);
