BEM.DOM.decl({ block: 'b-dynamic-conditions2', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._popup = this._getPopup();
            this._addConditionBtn = this.findBlockOn('add-link', 'link');
            this.model.on('isAddDisabled', 'change', function(e, data) {
                this._addConditionBtn.setMod('disabled', data.value ? 'yes' : '');
            }, this);

            this.model.init();
            this.model.fix();
        },

        type: function() {
            this._popup.hide();
        }
    },

    /**
     * Возвращает инстанс поп-апа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance(
            { size: 's', animate: 'no', autoclosable: false, 'has-close': 'yes', 'content-adaptive': 'yes' },
            {
                directions: [
                    'right-middle-middle',
                    { to: 'bottom', axis: 'left', offset: { right: 150 } },
                    { to: 'top', axis: 'left', offset: { right: 150 } }
                ]
            },
            { content: { block: 'b-dynamic-conditions2', elem: 'popup-content' } });
    },

    /**
     * Обновляет содержимое поп-апа
     * @param {Object} conditionData - данные модели условия
     * @returns {BEM}
     * @private
     */
    _setPopupContent: function(conditionData) {
        var curr = this.params.currency,
            strategy = this.params.strategy,
            editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        editBlock && editBlock.destruct();

        this._popup.setContent(BEMHTML.apply({
            block: 'b-dynamic-condition-edit',
            condition: $.extend(conditionData, { currency: curr, strategy: strategy }),
            currency: curr
        }));

        return this;
    },

    /**
     * Скрывает поп-ап
     * @returns {BEM}
     * @private
     */
    _hideEditPopup: function() {
        this._popup.hide();

        return this;
    },

    /**
     * Открывает поп-ап для редактирования условия
     * @param {String} action - тип редактирования, (add / update)
     * @param {Jquery} switcher - кнопка, открывшая поп-ап (нужно для правильного позиционирования)
     * @private
     */
    _editInPopup: function(action, switcher) {
        var editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        editBlock
            .on('condition:edit:completed', function(e, resp) {

                this.model.set('conditionDraft', resp.modelData);

                var validationRes = this.model.validate();

                if (validationRes.valid) {
                    this._execAction(action, resp.id, resp.modelData);
                    this.model.syncToDM();
                    this.model.syncFromDM();
                    this._hideEditPopup()
                        ._renderList('detailed');
                } else {
                    editBlock.trigger('save:error', validationRes.errors.map(function(err) {
                        return err.text;
                    }).join(', '));
                }
            }, this)
            .onFirst('condition:edit:canceled', this._hideEditPopup, this);

        this._popup.toggle(switcher);
    },

    /**
     * Вызывает метод по actionName c переданными аргумаентами (id модели и данные модели)
     * @param {...String} actionName - имя метода
     * @private
     */
    _execAction: function(actionName) {
        var actions = {
            add: this._add,
            update: this._update
        };

        return actions[actionName].apply(this, Array.prototype.slice.call(arguments, 1));
    },

    /**
     * Добавляет условие в списке
     * @param {Number} id - id нового условия
     * @param {Object} data - данные нового условия
     * @private
     */
    _add: function(id, data) {
        var strategy = this.params.strategy;

        this.model.get('dynamic_conditions').add({
            dyn_id: id,
            condition_name: data.condition_name,
            condition: data.condition,
            price: data.price,
            price_context: data.price_context,
            strategy: strategy
        });
    },

    /**
     * Обновляет условие в списке
     * @param {Number} id - id условия
     * @param {Object} data - свежие данные условия
     * @private
     */
    _update: function(id, data) {
        var strategy = this.params.strategy;

        this.model.get('dynamic_conditions').getById(id).update({
            condition_name: data.condition_name,
            condition: data.condition,
            price: data.price,
            price_context: data.price_context,
            strategy: strategy
        });
    },

    /**
     * Удаляет условие из списка, на элементе listElem
     * @param {BEM} listElem - элемент списка
     * @param {Number} modelId - id модели условия
     * @private
     */
    _deleteCondition: function(listElem, modelId) {
        this.model.deleteCondition(modelId);

        var editBlock = this._popup.findBlockInside('b-dynamic-condition-edit');

        editBlock && editBlock.destruct();

        this._popup.hide();

        listElem.destruct();
    },

    /**
     * Выводит список условий
     * @param {String} type - вид отобржения условия
     * @private
     */
    _renderList: function(type) {
        var conditions = this.model.toJSON().dynamic_conditions,
            params = this.params;

        BEM.DOM.update(this.elem('list'),
            BEMHTML.apply(conditions.map(function(condition) {
                return {
                    block: 'b-dynamic-conditions2',
                    elem: 'list-item',
                    js: { modelId: condition.dyn_id },
                    groupId: params.modelParams.id,
                    type: type,
                    condition: condition,
                    strategy: params.strategy,
                    currency: params.currency
                };
            })));
    },

    /**
     * Обработчик переключения типа
     * Обновляет DM и VM и одновляет список
     * @param {String} type - вид отобржения условия
     * @private
     */
    _onTypeChange: function(type) {
        this.setMod('type', type);

        if (type == 'any') {
            this.model.saveTempHash('detailed');

            this.model.get('anyConditionTempHash').length ?
                this.model.restoreFromDraft('any') :
                this.model.setDefaultCondition();

        } else {
            this.model.saveTempHash('any');
            this.model.restoreFromDraft('detailed');
        }

        this.model.syncFromDM();
        this._renderList(type);
    }
}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'radio-button', function(e) {
                this._onTypeChange(e.block.val());
            }, this)
            .liveBindTo('add', 'click', function() {
                if (!this._popup.isShown() && this.model.get('canAdd')) {
                    this._setPopupContent({
                        strategy: this.params.strategy,
                        currCode: this.params.currency
                    })
                        ._editInPopup('add', this._addConditionBtn);
                }
            })
            .liveBindTo('delete-condition', 'click', function(e) {
                var elem = this.closestElem($(e.target), 'list-item'),
                    listElem = this.elemInstance($(elem));

                this.model.get('canDelete') && this._deleteCondition(listElem, listElem.params.modelId);
            })
            .liveInitOnBlockInsideEvent('click', 'button', function(e) {
                if (!this._popup.isShown()) {
                    var elem = this.closestElem(e.target.domElem, 'list-item'),
                        listElem = this.elemInstance($(elem));

                    this._setPopupContent(
                            this.model.get('dynamic_conditions').getById(listElem.params.modelId).toJSON())
                        ._editInPopup('update', e.target);
                }
            }, this);

        return false;
    }
});
