BEM.MODEL.decl({ name: 'b-dynamic-conditions2', baseModel: 'vm-sync-dm' }, {
    /**
     * коллекция условий
     */
    dynamic_conditions: {
        type: 'models-list',
        modelName: 'b-dynamic-condition2'
    },

    /**
     * данные модели-черновика, для проверки перед обновлением и добавлением в список
     */
    conditionDraft: {
        type: 'object',
        internal: true
    },

    /**
     * флаг - можно ли сохранять черновик
     */
    canDraftBeSaved: {
        type: 'boolean',
        internal: true,
        calculate: function() {
            if (this.get('conditionDraft')) {
                var draft = this.get('conditionDraft'),
                    draftGoalsState = draft.goalsState,
                    draftId = draft.dyn_id;

                return this.get('dynamic_conditions').every(function(condition) {
                    var goalState = condition.getGoalsState();

                    return (draftId !== condition.id) && (draftGoalsState.length == goalState.length) ?
                        !draftGoalsState.every(function(draftSt) {
                            return goalState.indexOf(draftSt) >= 0;
                        }) :
                        true;
                })
            }
        },
        validation: {
            rules: {
                required: {
                    text: iget2('b-dynamic-conditions2', 'uslovie-s-takim-sochetaniem', 'Условие с таким сочетанием правил уже существует в группе'),
                    validate: function() {
                        // чтобы сработал calculate
                        return this.get('canDraftBeSaved');
                    },

                    needToValidate: function() {
                        return this.get('conditionDraft');
                    }
                }
            }
        }
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-dynamic-group',
                id: this.id
            };
        }
    },

    /**
     * флаг - есть ли хотябы одно условие в коллекции
     */
    isAnyCondition: {
        type: 'boolean',
        dependsFrom: 'dynamic_conditions',
        internal: true,
        calculate: function() {
            return this.get('dynamic_conditions').length() > 0;
        }
    },

    /**
     * флаг - можно ли добавлять условия в коллекцию
     */
    canAdd: {
        type: 'boolean',
        dependsFrom: 'dynamic_conditions',
        internal: true,
        calculate: function() {
            return this.get('dynamic_conditions').length() < 50;
        }
    },

    /**
     * флаг - видно ли кнопку добавления нового условия
     */
    isAddDisabled: {
        type: 'boolean',
        dependsFrom: 'canAdd',
        internal: true,
        calculate: function() {
            return !this.get('canAdd');
        }
    },

    /**
     * флаг - можно ли удалять из коллекции
     */
    canDelete: {
        type: 'boolean',
        dependsFrom: 'dynamic_conditions',
        internal: true,
        calculate: function() {
            return !this.get('isDefaultCondition');
        }
    },

    /**
     * флаг - является ли условия в коллекцие условием по умолчанию (any)
     */
    isDefaultCondition: {
        type: 'boolean',
        dependsFrom: 'dynamic_conditions',
        internal: true,
        calculate: function() {
            return this.get('dynamic_conditions').every(function(cond) {
                return cond.get('isDefaultGoal');
            });
        }
    },

    /**
     * Текст пустого списка
     */
    emptyListText: {
        type: 'string',
        internal: true,
        default: iget2('b-dynamic-conditions2', 'ne-zadano-ni-odnogo', 'Не задано ни одного условия')
    },

    /**
     * Текст переполненного списка
     */
    overflowText: {
        type: 'string',
        internal: true,
        default: iget2(
            'b-dynamic-conditions2',
            'dostignuto-maksimalnoe-kolichestvo-usloviy',
            'Достигнуто максимальное количество условий нацеливания на группу'
        )
    },

    /**
     * массив для сохранения детальных настроек условий
     * нужно для восстановления при переключении все страницы -> группа страниц)
     */
    detailedConditionsTempHash: {
        type: 'array',
        default: [],
        internal: true
    },

    /**
     * массив для сохранения any условия
     * нужно для восстановления при переключении все страницы -> группа страниц)
     */
    anyConditionTempHash: {
        type: 'array',
        default: [],
        internal: true
    }
}, {

    /**
     * Готовит данные для синхронизации в DM
     */
    prepareDataToDM: function(data) {
        data.dynamic_conditions.forEach(function(condition) {
            condition.condition.forEach(function(goal) {
                goal.value = u['b-dynamic-goal-edit-value'].convertValuesToStringArray(goal);
            });
        });

        return { dynamic_conditions: data.dynamic_conditions };
    },

    /**
     * Готовит данные для синхронизации из DM
     */
    prepareDataFromDM: function(data) {
        data.dynamic_conditions.forEach(function(condition) {
            condition.condition.forEach(function(goal) {
                goal.value = u['b-dynamic-goal-edit-value'].makeValueArray(goal);
            });
        });

        return { dynamic_conditions: data.dynamic_conditions };
    },

    /**
     * Очищает коллекцию условий
     */
    clearConditions: function() {
        this.getDM().clearConditions();
    },

    /**
     * Сбрасывает все условия у устанавливает условие типа any
     */
    setDefaultCondition: function() {
        this.clearConditions();
        this.getDM().addAnyCondition();
    },

    /**
     * Восстанавливает коллекцию условий из сохраненных условия
     * @param {String} type - тип условия нацеливания (any || detailed)
     */
    restoreFromDraft: function(type) {
        var draftList = this.get(type == 'any' ? 'anyConditionTempHash' : 'detailedConditionsTempHash');

        this.clearConditions();
        this.getDM().set('dynamic_conditions', draftList || []);
    },

    /**
     * Возвращает хеш с условиями
     */
    getStorageConditionsData: function() {
        return this.getDM().toJSON().dynamic_conditions;
    },

    /**
     * Сохраняет хеш с условиями
     * @param {String} type - тип условия нацеливания (any || detailed)
     */
    saveTempHash: function(type) {
        var conditionsData = this.getStorageConditionsData(),
            tempHashName = type == 'any' ? 'anyConditionTempHash' : 'detailedConditionsTempHash';

        this.set(tempHashName, conditionsData || []);
    },

    /**
     * Удаляет условие
     * @param {Number} id - id модели усовия
     */
    deleteCondition: function(id) {
        this.get('dynamic_conditions').getById(id).destruct();
        this.getDM().get('dynamic_conditions').getById(id).destruct();
    }
});
