BEM.DOM.decl({ block: 'b-dynamic-goal-edit-value', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this.goal = BEM.MODEL.getOne({ name: 'b-dynamic-goal-edit', id: this.params.goalModelId });

            u.graspSelf.call(this, {
                input: 'input on input',
                btnAddValue: 'button on btn-add-value',
                btnDeleteValue: 'button on btn-delete-value'
            });

            this.statusMessage = this.elem('status-message');

            this.goal
                .on('canAdd', 'change', this._setAddButtonState, this)
                .on('canDelete', 'change', this._setDeleteButtonState, this);

            this.btnAddValue.on('click', function() {
                this.goal.get('canAdd') && this.trigger('add-goal-value');
            }, this);

            this.btnDeleteValue.on('click', function() {
                this.goal.get('canDelete') && this.trigger('delete-goal-value');
            }, this);

            this.model
                .on('isUrl', 'change', function() {
                    this.model.fixUrlValue();
                }, this)
                .on('validated', this._showErrors, this);
        }
    },

    _setAddButtonState: function() {
        this.btnAddValue.setMod('disabled', this.goal.get('canAdd') ? '' : 'yes');
    },

    _setDeleteButtonState: function() {
        this.btnDeleteValue.setMod('disabled', this.goal.get('canDelete') ? '' : 'yes');
    },

    _showErrors: function(e, data) {
        if (data.valid) {

            this.delMod('error');
            this.statusMessage.empty();
        } else {

            this.statusMessage.text(data.errors.map(function(err) {
                return err.text;
            }).join(', '));

            this.setMod('error', 'yes');
            this.input.setMod('focused', 'yes');
        }
    },

    destruct: function() {
        this.goal.un('canDelete', 'change', this._setDeleteButtonState, this);
        this.model.destruct();
        this.__base();
    }
});
