u.register({
    'b-dynamic-goal-edit-value': {

        /**
         * Формирует на основе массива строк и информации о типе условия нацеливания
         * массив объектов, по структуре совпадающих с b-dynamic-goal-edit-value
         * @param {Object[]} goal объект, по структуре совпадающий с b-dynamic-goal-edit
         * @returns {Object[]}
         */
        makeValueArray: function(goal) {
            var isUrl = goal.type === 'URL_prodlist';

            return (goal.value || []).map(function(str) {
                return {
                    isUrl: isUrl,
                    value: str
                };
            });
        },

        /**
         * Преобразует array-list с типом элементов b-dynamic-goal-edit-value в массив строк (поле value каждого элемента)
         * @param {Object[]} goal объект, по структуре совпадающий с b-dynamic-goal-edit
         * @returns {Object[]}
         */
        convertValuesToStringArray: function(goal) {
            return (goal.value || []).map(function(obj) {
                return obj.value;
            });
        }
    }
});
