BEM.MODEL.decl('b-dynamic-goal-edit-value', {

    isUrl: {
        type: 'boolean'
    },

    /**
     * значение цели
     */
    value: {
        type: 'string',
        preprocess: function(val) {
            return val && this.model.get('isUrl') && !/^https?:\/\//.test(val) ? 'http://' + val : val;
        },
        validation: {
            rules: {
                required: {
                    text: iget2('b-dynamic-goal-edit-value', 'ukazhite-znachenie', 'Укажите значение')
                },
                maxLength: {
                    value: 100,
                    text: iget2('b-dynamic-goal-edit-value', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 100
                    }),
                    needToValidate: function(val) {
                        return !!val && !this.get('isUrl');
                    }
                },
                url: {
                    text: iget2('b-dynamic-goal-edit-value', 'vvedite-korrektnyy-url', 'Введите корректный URL'),
                    validate: function() {
                        return u.validation.isUrl(this.get('value'));
                    },
                    needToValidate: function(val) {
                        return !!val && this.get('isUrl');
                    }
                },
                urlProdMaxLength: {
                    text: iget2('b-dynamic-goal-edit-value', 'maksimalnaya-dlina-s-ssylki', 'Максимальная длина ({foo}) ссылки превышена', {
                        foo: u.consts('MAX_URL_LENGTH')
                    }),
                    validate: function() {
                        return this.get('value').length <= u.consts('MAX_URL_LENGTH');
                    },
                    needToValidate: function(val) {
                        return !!val && this.get('isUrl');
                    }
                },
                hasOnlyAllowedSymbols: {
                    text: iget2(
                        'b-dynamic-goal-edit-value',
                        'v-pravilah-dopuskaetsya-ispolzovanie-uzbekskogo',
                        'В правилах допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского, узбекского алфавитов, цифр и знаков пунктуации'
                    ),
                    validate: function() {
                        return u.validation.isAllowedForBannerString(this.get('value'));
                    }
                }
            }
        }
    },

    /**
     * флаг - уникален ли набор условий цели
     */
    isUnique: {
        type: 'boolean',
        internal: true,
        default: true,
        validation: {
            rules: {
                required: {
                    text: iget2('b-dynamic-goal-edit-value', 'takoy-nabor-usloviy-uzhe', 'Такой набор условий уже создан'),
                    validate: function(val) {
                        return !!val
                    },
                    needToValidate: function() {
                        return !!this.get('value');
                    }
                }
            }
        }
    }
}, {
    fixUrlValue: function() {
        var val = this.get('value');

        if (val && this.get('isUrl') && !/^https?:\/\//.test(val))
            this.set('value', 'http://' + val);
    }
});
