block('b-dynamic-goal-edit')(

    js()(function() {
        return {
            modelParams: {
                name: 'b-dynamic-goal-edit',
                id: this.ctx.goal.id,
                parentName: this.ctx.parentModelName || 'b-dynamic-condition-edit',
                parentId: this.ctx.parentId
            }
        };
    }),

    elem('setting').content()(function() {
        this.ctx.control.mix = this.ctx.control.mix || [];
        this.ctx.control.mix.push({
            block: 'b-dynamic-goal-edit',
            elem: 'model-field',
            js: {
                name: this.ctx.fieldName,
                type: this.ctx.controlType
            }
        });

        return [
            {
                elem: 'control',
                mix: { name: this.ctx.fieldName },
                content: this.ctx.control
            },
            {
                elem: 'error-message'
            }
        ]
    }),

    elem('setting-value').content()(function() {
        var goal = this.ctx.goal;

        return [
            {
                elem: 'setting-value-items',
                content: this.ctx.value.map(function(item, index, array) {
                    return {
                        block: 'b-dynamic-goal-edit-value',
                        data: item,
                        goal: goal,
                        mods: { 'is-last': index === array.length - 1 ? 'yes' : '' },
                        js: {
                            goalModelId: goal.id,
                            modelParams: {
                                name: 'b-dynamic-goal-edit-value',
                                id: item.id
                            }
                        }
                    };
                })
            },
            {
                elem: 'status-message'
            }
        ];
    }),

    content()(function() {
        var goal = this.ctx.goal,
            canUseUrlProdlistType = this.ctx.canUseUrlProdlistType,
            getTypeOptions = function(goal, canUseUrlProdlistType) {
                var all = goal.get('typeTitles'),
                    current = goal.get('type');

                return Object.keys(all).filter(function(key) {
                    return canUseUrlProdlistType !== 'none' || key !== 'URL_prodlist' || key === current;
                }).map(function(key) {
                    return {
                        elem: 'option',
                        attrs: key == current ?
                        {
                            value: key,
                            selected: 'selected'
                        } :
                        {
                            value: key
                        },
                        content: all[key]
                    };
                });
            },

            getKindOptions = function(goal, canUseUrlProdlistType) {
                var type = goal.get('type'),
                    all = goal.get('kindTitles'),
                    rules = goal.get('rules')[type] || [],
                    current = goal.get('kind');

                return rules.filter(function(key) {
                    return type !== 'URL_prodlist' || canUseUrlProdlistType === 'both' ||
                        key === canUseUrlProdlistType || key === current;
                }).map(function(key) {
                    return {
                        elem: 'option',
                        attrs: key == current ?
                        {
                            value: key,
                            selected: 'selected'
                        } :
                        {
                            value: key
                        },
                        content: all[key]
                    };
                });
            };

        return [
            {
                elem: 'setting',
                elemMods: { field: 'type' },
                fieldName: 'type',
                controlType: 'select',
                control: {
                    block: 'select',
                    mix: [{
                        block: 'b-dynamic-goal-edit',
                        elem: 'type'
                    }],
                    content: [
                        {
                            block: 'button'
                        },
                        {
                            elem: 'control',
                            content: getTypeOptions(goal, canUseUrlProdlistType)
                        }
                    ]
                }
            },
            {
                elem: 'setting',
                elemMods: { field: 'kind' },
                fieldName: 'kind',
                controlType: 'select',
                control: {
                    block: 'select',
                    mix: [{
                        block: 'b-dynamic-goal-edit',
                        elem: 'kind',
                        elemMods: { type: 'select' }
                    }],
                    content: [
                        {
                            block: 'button'
                        },
                        {
                            elem: 'control',
                            content: getKindOptions(goal, canUseUrlProdlistType)
                        }
                    ]
                }
            },
            {
                elem: 'setting-value',
                value: goal.get('value'),
                goal: goal
            }
        ];
    })
);
