BEM.DOM.decl({ block: 'b-dynamic-goal-edit', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            // todo@dima117a добавить в тестах создание родительской модели
            this.condition = this._getParentModel() || BEM.MODEL.create('b-dynamic-condition-edit');

            this._updateIsUrlField(true);

            u.graspSelf.call(this, {
                goalTypeSelect: 'select on type',
                goalKindSelet: 'select on kind'
            });

            this.goalTypeSelect.on('change', function(e) {
                this._updatePropertValsSelect(e.block.val());
            }, this);

            // формирует объект вариантов для kind селекта
            this.propsOptions = Object.keys(this.model.get('rules')).reduce(function(props, key) {
                props[key] = this.model.get('rules')[key].map(function(rule) {
                    return {
                        item: 'option',
                        value: rule,
                        selected: rule == this.model.get('kind'),
                        content: this.model.get('kindTitles')[rule]
                    };
                }, this);

                return props;
            }.bind(this), {});

            this.model
                .on('type', 'change', this._updateIsUrlField, this)
                .on('validated', function(e, data) {
                    data.valid ? this._clearErrors() : this._showErrors(data);
                }, this);

            this._initEvents();
        }
    },

    _initEvents: function() {
        this._listener = BEM.create('i-subscription-manager');

        this._listener.wrap(this.condition)
            .on('canUseUrlProdlistType', 'change', this._updateSelects, this);

        BEM.blocks['b-dynamic-goal-edit-value']
            .on(this.domElem, 'add-goal-value', this._addValue, this)
            .on(this.domElem, 'delete-goal-value', this._deleteValue, this);

        //todo@dima117a перенести сюда все события
    },

    /**
     * Удаляет подписки на события блока
     * Сделано в отдельном методе, чтобы можно было отписать несколько блоков от событий без удаления моделей
     */
    unbindEvents: function() {
        if (this._listener) {
            BEM.blocks['b-dynamic-goal-edit-value'].un(this.domElem);

            this._listener.dispose();
            this._listener = null;
        }
    },

    _updateIsUrlField: function(needToFix) {
        var isUrl = this.model.get('type') === 'URL_prodlist';
        this.model.get('value').forEach(function(value) {
            value.set('isUrl', isUrl);
            needToFix && value.fix();
        });
    },

    _getParentModel: function() {
        var modelParams = this.params.modelParams;
        return BEM.MODEL.getOne(modelParams.parentName, modelParams.parentId);
    },

    _updateSelects: function() {
        var availableValue = this.condition.get('canUseUrlProdlistType'),
            type = this.model.get('type'),
            kind = this.model.get('kind'),
            all, options;

        if (type === 'URL_prodlist') {
            // если выбран тип URL_prodlist, фильтруем список операторов
            options = this.propsOptions[type]
                .map(function(option) {
                    option.selected = option.value === kind;
                    return option;
                })
                .filter(function(option) {
                    return availableValue === 'both' || option.value === availableValue || option.selected;
                });

            options && this.goalKindSelet.setOptions(options);
        } else {
            // если выбран другой тип, то фильтруем список типов
            all = this.model.get('typeTitles');
            options = Object.keys(all).filter(function(key) {
                return availableValue !== 'none' || key !== 'URL_prodlist' || key === type;
            }).map(function(key) {
                return {
                    item: 'option',
                    value: key,
                    selected: key == type,
                    content: all[key]
                };
            });

            options && this.goalTypeSelect.setOptions(options); // todo@dima117a: вынести эту логику в utils или в модель и использовать в шаблонах и js
        }
    },

    _addValue: function(e) {

        if (this.model.get('canAdd')) {
            var item = this.model.get('value').add({ value: '', isUrl: this.model.get('type') == 'URL_prodlist' }),
                domElem;

            domElem = BEM.DOM.after(e.target.domElem, BEMHTML.apply({
                block: 'b-dynamic-goal-edit-value',
                data: item,
                goal: this.model,
                js: {
                    goalModelId: this.model.id,
                    modelParams: {
                        name: 'b-dynamic-goal-edit-value',
                        id: item.id
                    }
                }
            }));

            this._updateIsLastMod();
            this.trigger('add-value', { domElem: domElem });
        }
    },

    _deleteValue: function(e) {
        this.model.get('value').remove(e.target.model.id);
        e.target.destruct();
        this._updateIsLastMod();
    },

    /**
     * Обновляет модификатор is-last у условий
     * @private
     */
    _updateIsLastMod: function() {
        this.findBlocksInside('b-dynamic-goal-edit-value').forEach(function(el, index, array) {
            el.setMod('is-last', index === array.length - 1 ? 'yes' : '');
        });
    },

    /**
     * Обновляет список option для селекта kind
     * @param {String} type - тип сонтента в цели
     * @private
     */
    _updatePropertValsSelect: function(type) {
        var availableValue = this.condition.get('canUseUrlProdlistType'),
            kind = this.model.get('kind'),
            options = this.propsOptions[type].map(function(option) {
                option.selected = option.value === kind;
                return option;
            })
            .filter(function(option) {
                return type !== 'URL_prodlist' || availableValue === 'both' || option.value === availableValue ||
                    option.selected;
            });

        options && this.goalKindSelet.setOptions(options);
    },

    /**
     * Уничтожает модель и блок
     * @private
     */
    destruct: function() {
        this.unbindEvents();
        this.model.destruct();
        this.__base();
    },

    /**
     * Отмечает ошибочный контрол красной рамкой и фокусируется на нем
     * @param {String} fieldName - имя поля с ошибкой
     * @private
     */
    _markControl: function(fieldName) {
        var blockControlName = this.getMod(this.elem(fieldName), 'type'),
            controlBlock = this.findBlockOn(fieldName, blockControlName);

        this.setMod(this.findElem('setting', 'field', fieldName), 'error', 'yes');
        controlBlock && controlBlock.setMod('focused', 'yes');
    },

    /**
     * Выводит текстовки ошибок
     * @param {Array} errorsArray - Массив ошибок
     * @private
     */
    _renderErrorText: function(errorsArray) {
        this.elem('status-message').text(errorsArray.map(function(err) {
            return err.text;
        }).join(', '));
    },

    /**
     * Визуально маркирует ошибочные контролы и выводит ошибки
     * @param {Object} data - объект с данными ошибок валидации
     * @private
     */
    _showErrors: function(data) {
        data.errorFields.forEach(function(fieldName) {
            this._markControl(fieldName)
        }, this);

        this._renderErrorText(data.errors);
    },

    /**
     * Стирает тексты ошибок, убирает маркировку с контролов
     * @private
     */
    _clearErrors: function() {
        this.delMod(this.elem('setting'), 'error');
        this.elem('status-message').empty();
    }
});
