BEM.MODEL.decl({ name: 'b-dynamic-goal-edit', baseModel: 'vm-dynamic-goal' }, {
    /**
     * значение цели
     */
    value: {
        type: 'models-list',
        modelName: 'b-dynamic-goal-edit-value',
        default: [],
        validation: {
            rules: {
                required: {
                    validate: function() {
                        return this.get('value').reduce(function(res, model) {
                            return res && model.isValid();
                        }, true);
                    }
                }
            }
        }
    },

    /**
     * флаг - можно ли добавлять условия в коллекцию
     */
    canAdd: {
        type: 'boolean',
        dependsFrom: 'value',
        internal: true,
        calculate: function() {
            return this.get('value').length() < 10;
        }
    },

    /**
     * флаг - можно ли удалять условия
     */
    canDelete: {
        type: 'boolean',
        dependsFrom: 'value',
        internal: true,
        calculate: function() {
            this.updateValueUniqueField();
            return this.get('value').length() > 1;
        }
    },

    /**
     * флаг - уникален ли набор условий цели
     */
    isUnique: {
        type: 'boolean',
        internal: true,
        default: true,
        validation: {
            rules: {
                required: {
                    text: iget2('b-dynamic-goal-edit', 'takoy-nabor-usloviy-uzhe', 'Такой набор условий уже создан'),
                    validate: function(val) {
                        return !!val
                    },
                    needToValidate: function() {
                        return this.get('value').every(function(obj) { return !!obj.get('value'); });
                    }
                }
            }
        }
    }
}, {
    /**
     * Обновляет флаг isUnique во вложенных моделях значений
     */
    updateValueUniqueField: function() {
        var store = {};

        this.get('value').forEach(function(model) {
            var str = model.get('value'),
                isUsed = store[str];

            if (!isUsed) store[str] = true;

            model.set('isUnique', !isUsed);
        }, []);
    }
});
