BEM.DOM.decl({ block: 'b-dynamic-group-domain', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();
            this.model.init();

            this._subMan = BEM.create('i-subscription-manager');

            var debouncedDomainChangeHandler = $.debounce(function(e, obj) {
                this.model.validate('domain').valid && this._ajaxCheck(obj.value);
                this.model.syncToDM();
            }, 500, this);

            this._subMan.wrap(this.model)
                .on('domain', 'change', debouncedDomainChangeHandler, this)
                .on('ajaxCheckPassed marketRating', 'change', function() {
                    this.model.syncToDM();
                }, this)
                .on('domainErrorText ajaxCheckPending ajaxErrorText', 'change', this._updateWarnings, this);

        }
    },

    /**
     * Деструтор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base();
    },

    /**
     * Выполняет аякс проверку и обновляет модель результирующим объектом
     * @param {String} domainStr - строка домена
     * @private
     */
    _ajaxCheck: function(domainStr) {
        var domainIsNotEmpty = !!domainStr;

        this.model.update({
            ajaxErrorText: '',
            ajaxCheckPassed: false,
            ajaxCheckPending: domainIsNotEmpty,
            marketRating: -1
        });

        if (domainIsNotEmpty) {
            u.urlCheckAndGetMarketRating({
                url: domainStr,
                callback: function(data) {
                    //еще мб код 2: редирект есть, но мы его считаем допустимым,
                    // например, с http на https или на субдомен (domain.com -> www.domain.com)
                    var hasInvaldRedirect = data.has_redirect === 1;

                    this.model.update({
                        ajaxErrorText: hasInvaldRedirect ?
                            iget2('b-dynamic-group-domain', 'v-pole-domen-ne', 'В поле домен не допускается указание ссылки с редиректом.') :
                            data.text || '',
                        ajaxCheckPassed: !!data.code && !hasInvaldRedirect,
                        ajaxCheckPending: false,
                        marketRating: (+data.market_rating) || -1
                    });
                },
                ctx: this,
                protocol: 'http'
            });
        }
    },

    _updateWarnings: function() {

        var domainError = this.model.get('domainErrorText'),
            ajaxError = this.model.get('ajaxErrorText'),
            ajaxCheckPending = this.model.get('ajaxCheckPending'),

            msgDomain = this.elem('domain-message');

        // проверка домена
        msgDomain.text(domainError || ajaxError || (ajaxCheckPending && this.model.get('pendingText')) || '');
        this.setMod(msgDomain, 'type',
            domainError || ajaxError ?
            'error' :
                ajaxCheckPending ? 'hint' : 'hidden');

        // модификатор pending
        (!domainError && !ajaxError && ajaxCheckPending && this.setMod('pending', 'yes')) || this.delMod('pending');
    }
});
