BEM.MODEL.decl({ name: 'b-dynamic-group-domain', baseModel: 'vm-sync-dm' }, {
    /**
     * домен для динамической группы
     */
    domain: {
        type: 'string',
        preprocess: function(val) {
            return u.extractDomain(val);
        },
        validation: {
            rules: {
                maxLength: {
                    value: u.consts('MAX_URL_LENGTH'),
                    text: u.pluralForms(iget2(
                        'b-dynamic-group-domain',
                        'prevyshena-maksimalnaya-dlina-domena',
                        'Превышена максимальная длина домена, {foo} {символ|символа|символов}.',
                        {
                            foo: u.consts('MAX_URL_LENGTH')
                        }
                    ), u.consts('MAX_URL_LENGTH')),
                    needToValidate: function(val) {
                        return !!val;
                    }
                },
                isCorrectURL: {
                    text: iget2('b-dynamic-group-domain', 'domen-ukazan-neverno', 'Домен указан неверно.'),
                    validate: function(val) {
                        return u.isUrl(val);
                    },
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    /* Сообщения об ошибках */

    /**
     * Ошибка в названии домена
     */
    domainErrorText: {
        type: 'string',
        internal: true
    },

    /**
     * Ошибка при ajax проверке домена
     */
    ajaxErrorText: {
        type: 'string',
        internal: true
    },

    /**
     * Флаг: идет ajax проверка домена
     */
    ajaxCheckPending: {
        type: 'boolean',
        internal: true
    },

    /**
     * Максимальная длинна домена
     */
    lengthLimit: {
        type: 'number',
        internal: true
    },

    /**
     * Флаг - прошел ли домен аякс проверку
     */
    ajaxCheckPassed: {
        type: 'boolean',
        default: true,
        dependsFrom: 'domain',
        calculate: function() {
            // сбрасываем флаг при изменении домена
            return !this.isChanged('domain');
        }
    },

    /**
     * Текстовка для вывода ошибки о неверном формате домена
     */
    wrongFormatText: {
        type: 'string',
        internal: true,
        default: iget2('b-dynamic-group-domain', 'domen-ukazan-neverno-106', 'Домен указан неверно')
    },

    /**
     * Текстовка для отображения процесса аякс проверки
     */
    pendingText: {
        type: 'string',
        internal: true,
        default: iget2('b-dynamic-group-domain', 'odnu-sekundu-vypolnyaetsya-proverka', 'Одну секунду, выполняется проверка домена...')
    },

    /**
     * Рейтинг магазина в маркете
     */
    marketRating: {
        type: 'number',
        default: -1
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        calculate: function() {
            return {
                name: 'dm-dynamic-group',
                id: this.id
            };
        }
    }
}, {
    init: function() {
        this.__base.apply(this, arguments);

        this.fix();

        // dima117a@todo: сделать нормальную асинхронную валидацию моделей и выпилить этот флаг
        this.set('ajaxCheckPassed', true);

        this.getDM()
            .on('main_domain href_params', 'change', this.syncFromDM, this);

        this.on('validated', this.updateErrorMessages, this);
    },
    syncToDM: function() {
        this._setToDM();
        this.trigger('sync:ok');
    },
    /**
     * Готовит данные для синхронизации в DM
     */
    prepareDataToDM: function(data) {
        return {
            main_domain: data.domain,
            isMainDomainValid: data.ajaxCheckPassed,
            market_rating: data.marketRating
        };
    },

    /**
     * Готовит данные для синхронизации из DM
     */
    prepareDataFromDM: function(data) {
        return {
            domain: data.main_domain,
            marketRating: data.market_rating
        };
    },

    updateErrorMessages: function(e, res) {

        var data = {},
            map = { domain: 'domainErrorText', params: 'paramsErrorText' },
            getErrorMessage = function(errors) {
                return errors && errors.length ? errors.map(function(error) { return error.text; }).join(' ') : '';
            };

        if (res.field && map[res.field]) {
            data[map[res.field]] = getErrorMessage(res.errors);
            this.update(data);
        }
    }
});
