/**
 * @see {b-dynamic-media-creative-list}
 * @param {String} this.ctx.currentBannerId идентификатор редактируемого баннера
 */
block('b-dynamic-media-creative-list').mod('type', 'choose-single')(
    mix()(function() {
        var res = applyNext() || [];

        if (!Array.isArray(res)) {
            res = [res];
        }

        res.push({
            block: 'i-selectable',
            mods: { type: 'single-choice' }
        });

        return res;
    }),

    elem('empty-message').content()(function() {
        return iget2('b-dynamic-media-creative-list', 'net-dostupnyh-bannerov', 'Нет доступных баннеров');
    }),

    elem('items-wrapper').match(function() {
        return this.ctx.items && this.ctx.items.length;
    }).def()(function() {
        return applyCtx({
            block: 'radiobox',
            mix: {
                block: 'b-selectable-control',
                mods: { type: 'radiobox' },
                js: {
                    items: this.ctx.items.reduce(function(acc, item) {
                        acc[item.creative_id] = item;

                        return acc;
                    }, {})
                }
            },
            content: applyNext()
        });
    }),

    elem('item').content()(function() {
        return [
            {
                block: 'radiobox',
                elem: 'radio',
                controlAttrs: { value: this.ctx.creative.creative_id },
                mix: {
                    block: 'b-dynamic-media-creative-list',
                    elem: 'item-selector'
                }
            },
            applyNext()
        ];
    })
);
