BEM.DOM.decl({ block: 'b-dynamic-media-creative-list', modName: 'type', modVal: 'choose-single' }, {
    /**
     * Инициализация списка элементов
     * @private
     */
    _initItemsList: function() {
        this.__base.apply(this, arguments);

        this._subscriptionManager.on(this._listItems, 'selectedChanged', function() {
            var selected = this._getSelectedIdsFromItemsList();

            this.model.set('selectedItemsIds', selected);

            this._triggerSelectedChanged(selected);
        }, this);
    },

    /**
     * Триггерит событие "Выбранные элементы изменились"
     * @param {Boolean} selected
     * @private
     */
    _triggerSelectedChanged: function(selected) {
        this.trigger('selectedChanged', { selected: selected });
    }
});
