block('b-dynamic-media-creative-list')(
    def()(function() {
        var controlsType = this.ctx.controlsType,
            type = this.mods.type;

        if (controlsType == 'replace') {
            type = 'choose-single';
        }

        return applyNext({
            'mods.type': type
        });
    }),

    js()(function() {
        var isEditMode = ['edit', 'edit-popup'].indexOf(this.ctx.controlsType) !== -1,
            otherIds = this.ctx.otherIds || [],
            allSelectedItemsIds = u['b-dynamic-media-creative-list'].filterSelectable(
                this.ctx.selectedItemsIds,
                isEditMode
            ),
            otherSelectableIds = u['b-dynamic-media-creative-list'].filterSelectable(otherIds, isEditMode),
            selectedItemsIds = [],
            selectedOtherItemsIds = allSelectedItemsIds.filter(function(selected) {
                if (u._.findIndex(otherIds, function(other) { return other.id == selected.id; }) !== -1) {
                    return true;
                }
                selectedItemsIds.push(selected);

                return false;
            }, this),
            ctx = this.ctx;

        return {
            controlsType: ctx.controlsType,
            items: ctx.items,
            modelData: {
                isEditMode: isEditMode,
                otherSelectableIds: otherSelectableIds,
                selectedOtherItemsIds: selectedOtherItemsIds,
                selectedItemsIds: selectedItemsIds,
                otherIds: otherIds,
                fromChanged: this.ctx.fromChanged,
                isSearch: this.ctx.isSearch
            }
        };
    }),

    elem('items-wrapper').def()(function() {
        return applyCtx({
            elem: 'empty-message',
            content: this.ctx.isSearch ? iget2('b-dynamic-media-creative-list', 'po-vashemu-zaprosu-nichego', 'По вашему запросу ничего не найдено') : iget2('b-dynamic-media-creative-list', 'net-sozdannyh-bannerov', 'Нет созданных баннеров')
        });
    }),

    elem('items-wrapper').match(function() {
        return this.ctx.items && this.ctx.items.length;
    }).def()(function() {
        return applyCtx({
            block: 'b-dynamic-media-creative-list',
            elem: 'items',
            content: this.ctx.items.map(function(item) {
                return [
                    {
                        block: 'b-dynamic-media-creative-list',
                        mods: { type: this.mods.type },
                        elem: 'item',
                        creative: item,
                        controlsType: this.ctx.controlsType
                    }
                ]
            }, this)
        });
    }),

    elem('items').tag()('ul'),

    elem('item').tag()('li'),

    elem('item').content()(function() {
        var controlsType = this.ctx.controlsType;

        return [
            { block: 'b-dynamic-media-creative-list', elem: 'item-index' },
            {
                block: 'b-dynamic-media-creative',
                notEditable: ['add', 'add-popup', 'replace'].indexOf(controlsType) !== -1 ||
                    controlsType == 'edit-popup' && this.ctx.creative.creative_group_id !== '0',
                creative: this.ctx.creative,
                ulogin: u.consts('ulogin')
            }
        ]
    })

);
