BEM.DOM.decl({
    block: 'b-dynamic-media-creative-list',
    baseBlock: 'i-glue',
    implements: 'i-creatives-list-interface'
}, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._initItemsList();
        }
    },

    /**
     * Добавляем модели новых баннеров в DOM
     * @param {Array} creatives
     * @param {Array} otherIds id креативов, которые есть в списке но сейчас не отрисованы
     * @returns {BEM}
     */
    addItems: function(creatives, otherIds) {
        var items = this.model.addItems(creatives);

        BEM.DOM.append(this.findElem('items'), BEMHTML.apply(items.map(function(item) {
            return {
                block: 'b-dynamic-media-creative-list',
                mods: { type: this.getMod('type') },
                elem: 'item',
                creative: item,
                controlsType: this.params.controlsType
            }
        }, this)));

        this.model.setOtherIds(otherIds);

        this._updateSelectable(u._.indexBy(items, 'creative_id'));

        return this;
    },

    /**
     * Изменился ли список выбранных элементов
     * @returns {Boolean}
     */
    isSelectedChanged: function() {
        return this.model.isChanged('selectedItemsIds') || this.model.get('fromChanged');
    },

    /**
     * Возвращает массив с id выбранных креативов
     * @returns {Object[]}
     */
    getSelectedIds: function() {
        return [].concat(this.model.get('selectedItemsIds')).concat(this.model.get('selectedOtherItemsIds'));
    },

    /**
     * Возвращает массив с выбранными креативами
     * @returns {Object[]}
     */
    getSelectedCreatives: function() {
        var selectedIds = this.getSelectedIds();

        return this.model.get('items').filter(function(itemModel) {
            return selectedIds.indexOf(itemModel.get('creative_id')) !== -1;
        }).map(function(itemModel) {
            return itemModel.toJSON();
        });
    },

    /**
     * Удаление блока
     */
    destruct: function() {
        this._subscriptionManager && this._subscriptionManager.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Из списка отрисованных элементов получаем список тех элементов, которые выбраны
     * @returns {Array}
     * @private
     */
    _getSelectedIdsFromItemsList: function() {
        return this._getItemsList().getSelected().map(function(elem) {
            return {
                id: elem.creative_id,
                creative_group_id: elem.creative_group_id,
                business_type: elem.business_type
            }
        });
    },

    /**
     * Инициализация списка элементов
     * @private
     */
    _initItemsList: function() {
        this._renderItemsList();

        this._listItems = this.findBlockOn(this.domElem, 'i-selectable');
    },

    /**
     * Отрисовываем список элементов
     * @private
     */
    _renderItemsList: function() {
        var items = [].concat(this.model.updateItemsList(this.params.items));

        BEM.DOM.update(this.domElem, BEMHTML.apply({
            block: 'b-dynamic-media-creative-list',
            mods: { type: this.getMod('type') },
            elem: 'items-wrapper',
            isSearch: this.model.get('isSearch'),
            isSelectedAllFlag: this.model.get('isSelectedAllFlag'),
            otherSelectableIds: this.model.get('otherSelectableIds'),
            shownSelectableItemsIds: this.model.get('shownSelectableItemsIds'),
            otherIds: this.model.get('otherIds'),
            items: items,
            controlsType: this.params.controlsType
        }))
    },

    /**
     * Возвращает контролл, управляюший выбором элементов из списка
     * @returns {BEM.DOM}
     * @private
     */
    _getItemsList: function() {
        return this._listItems || (this._listItems = this.findBlockOn(this.domElem, 'i-selectable'));
    },

    /**
     * Переинициализируем и обновляем параметры i-selectable
     * @param {Object} itemsToAdd
     * @private
     */
    _updateSelectable: function(itemsToAdd) {
        this._getItemsList().considerItemNodes({
            forceSearch: true,
            items: itemsToAdd
        });
    }

});
