u.register({
    'b-dynamic-media-creative-list': {
        /**
         * Отфильтровывает из списка креативов те креативы, которые не пренадлежат к старой фейковой группе
         * и могут быть выбраны на редактирование
         * @param {Array} itemsList
         * @param {Boolean} isEditMode флаг - выбор осущетвляется именно на редактирование
         * @returns {Array}
         */
        filterSelectable: function(itemsList, isEditMode) {
            itemsList = itemsList || [];

            return isEditMode ?
                itemsList.filter(function(item) {
                    return item.creative_group_id !== '0';
                }) :
                itemsList;
        }
    }
});
