BEM.MODEL.decl('b-dynamic-media-creative-list', {
    /**
     * список креативов которые показываются в настоящий момент
     */
    items: {
        type: 'models-list',
        modelName: 'b-dynamic-media-creative'
    },

    //выбранные элементы в показанном списке
    selectedItemsIds: {
        type: 'array',
        default: []
    },

    //элементы в списке выбираются именно на редактирование
    isEditMode: 'boolean',

    // значит что блок сформировался из данных, которые были изменены пользователем ранее
    fromChanged: 'boolean',

    //выбранные элементы, которые не показываюстя в данный момент
    //необходимо для попапа креативов для группы. После того, как один раз открыли и выбрали, этот выбор должен сохраняться при последующем открытии
    selectedOtherItemsIds: {
        type: 'array',
        default: []
    },

    //список id всех элементов, которые на данный момент отрисованы
    shownSelectableItemsIds: {
        type: 'array',
        dependsFrom: ['items'],
        calculate: function() {
            return this.get('items').filter(function(item) {
                return !this.get('isEditMode') || item.get('creative_group_id') !== '0';
            }, this).map(function(item) {
                return {
                    id: item.get('id'),
                    business_type: item.get('business_type'),
                    creative_group_id: item.get('creative_group_id')
                }
            })
        }
    },

    //id креативов которые на данный момент не показываются
    otherIds: {
        type: 'array',
        default: []
    },

    //id креативов которые на данный момент не показываются и могут быть выбраны
    otherSelectableIds: {
        type: 'array',
        default: []
    },

    //Галка "выбрать все"
    isSelectedAllFlag: {
        type: 'boolean',
        dependsFrom: ['selectedOtherItemsIds', 'selectedItemsIds', 'shownSelectableItemsIds', 'otherSelectableIds'],
        calculate: function() {
            if (!this.get('selectedOtherItemsIds') || !this.get('otherSelectableIds') ||
                !this.get('selectedItemsIds') || !this.get('shownSelectableItemsIds')) return false;

            var selectedOtherItemsIdsLength = this.get('selectedOtherItemsIds').length,
                otherSelectableIdsLength = this.get('otherSelectableIds').length,
                selectedItemsIdsLength = this.get('selectedItemsIds').length,
                shownSelectableItemsIdsLength = this.get('shownSelectableItemsIds').length;

            //число скрытых элементов равно числу скрытых выбранных элементов
            return (selectedOtherItemsIdsLength == otherSelectableIdsLength) &&
                //число показываемых элементов равно числу показываемых выбранных элементов
                (selectedItemsIdsLength == shownSelectableItemsIdsLength) &&
                //и хотя бы что-то не равно нулю
                (selectedOtherItemsIdsLength || selectedItemsIdsLength);
        }
    },

    //находимся в режиме поиска по креативам
    isSearch: 'boolean'

}, {
    /**
     * Добавляем новые креативы в модель
     * @param {Array} creatives
     * @returns {Array}
     */
    addItems: function(creatives) {
        var creativesModelsList = this.get('items');

        creatives = this._prepareDataFromDM(creatives);

        creatives.forEach(function(item) {
            creativesModelsList.add(item);
        });

        return creatives;
    },

    /**
     * Обновляем модель списка креативов
     * @param {Array} creatives
     * @returns {Array}
     */
    updateItemsList: function(creatives) {
        creatives = this._prepareDataFromDM(creatives);

        this.update({
            items: creatives
        });

        return creatives;
    },

    /**
     * После загрузки части креативов обновляет otherIds и выкусывает из selectedOtherItemsIds id элементов, которые теперь показываюстся
     * и следоватльно их id попадают в selectedItemsIds
     * @param {{ id: String, business_type: String}[]} otherIds
     */
    setOtherIds: function(otherIds) {
        var excludedOtherSelectedIds = [],
            newOtherSelectedIds = [].concat(this.get('selectedOtherItemsIds')).filter(function(selected) {
                if (this._findIndex(otherIds, selected) == -1) {
                    excludedOtherSelectedIds.push(selected);

                    return false
                }

                return true;
            }, this);

        this.set('otherIds', otherIds);
        this.set('selectedOtherItemsIds', newOtherSelectedIds);
        this.set('selectedItemsIds', [].concat(this.get('selectedItemsIds').concat(excludedOtherSelectedIds)));
    },

    _prepareDataFromDM: function(creatives) {
        return creatives.map(function(creative) {
            creative = u['b-dynamic-media-creative'].prepareDataFromDM(creative);

            creative.isSelected = this._findIndex(this.get('selectedOtherItemsIds'), creative) !== -1 ||
            this._findIndex(this.get('selectedItemsIds'), creative) !== -1;

            return creative;
        }, this);
    },

    _findIndex: function(list, elem) {
        return u._.findIndex(list, function(item) {
            return elem.creative_id == item.id || elem.id == item.id;
        });
    }
});
