block('b-dynamic-media-creative')(

    elem('camps-list')(
        tag()('ol'),

        content()(function() {
            return [
                {
                    elem: 'camps-list-items',
                    content: this.ctx.items.map(function(camp, i) {
                        return {
                            elem: 'camps-list-item',
                            elemMods: {
                                hidden: i >= this.campsLimit ? 'yes' : ''
                            },
                            data: camp,
                            ulogin: this.ctx.ulogin
                        }
                    }, this)
                },
                this.ctx.items.length > this.campsLimit && {
                    block: 'button',
                    mix: {
                        block: 'b-dynamic-media-creative',
                        elem: 'camps-list-toggle-rest'
                    },
                    mods: { theme: 'pseudo' },
                    content: [
                        iget2('b-dynamic-media-creative', 'eshchyo', 'Ещё'),
                        {
                            block: 'b-dynamic-media-creative',
                            elem: 'camps-list-rest-length',
                            limit: this.campsLimit,
                            num: this.ctx.items.length
                        }
                    ]
                }
            ];
        })),

    elem('camps-list-item')(
        tag()('li'),

        content()(function() {
            return [
                {
                    block: 'link',
                    mix: [{
                        block: 'b-dynamic-media-creative',
                        elem: 'camps-list-item-name'
                    }],
                    url: u.formatUrl({
                        path: '/registered/main.pl',
                        query: {
                            cmd: 'showCamp',
                            cid: this.ctx.data.cid,
                            ulogin: this.ctx.ulogin
                        }
                    }),
                    content: this.ctx.data.name
                },
                {
                    elem: 'camps-list-item-id',
                    content: this.ctx.data.cid
                }
            ];
        })
    ),

    elem('camps-list-item-id')(
        tag()('span'),

        content()(function() {
            return ' (№ ' + applyNext() + ')';
        })
    ),

    elem('camps-list-rest-length').content()(function() {
        return ' &mdash; ' + (this.ctx.num - this.ctx.limit);
    })
);
