block('b-dynamic-media-creative')(

    elem('camps-popup')(

        content()(function() {
            var campaigns = this.ctx.campaigns,
                campaign = campaigns[0];

            if (!campaign) return '&mdash;';

            if (campaigns.length > 1) {
                return {
                    block: 'button',
                    mods: { size: 'xs', pseudo: 'yes' },
                    mix: {
                        block: 'b-dynamic-media-creative',
                        elem: 'campaigns-popup-button',
                        js: { campaigns: campaigns }
                    },
                    content: iget2('b-dynamic-media-creative', 'vse-mdash-s', 'Все &mdash; {foo}', {
                        foo: campaigns.length
                    })
                };
            }

            return [
                {
                    elem: 'campaign-name',
                    content: {
                        block: 'link',
                        url: u.getUrl('showCamp', {
                            cid: campaign.cid,
                            ulogin: u.consts('ulogin')
                        }),
                        title: u.escapeHTML(campaign.name),
                        content: u.hellipCut(campaign.name, 35, u.escapeHTML)
                    }
                },
                {
                    elem: 'campaign-cid',
                    content: ['&nbsp;(', iget2('b-dynamic-media-creative', 'no', '№'), '&nbsp;', campaign.cid, ')']
                }
            ];
        })
    ),

    elem('camps-popup').elemMod('list', 'yes')(

        content()(function() {
            return this.ctx.campaigns.map(function(campaign) {
                return {
                    elem: 'campaign-popup-item',
                    content: [
                        {
                            block: 'link',
                            url: u.getUrl('showCamp', {
                                cid: campaign.cid,
                                ulogin: u.consts('ulogin')
                            }),
                            title: u.escapeHTML(campaign.name),
                            content: u.hellipCut(campaign.name, 150, u.escapeHTML)
                        },
                        '&nbsp;(', iget2('b-dynamic-media-creative', 'no', '№'), '&nbsp;', campaign.cid, ')'
                    ]
                };
            });
        })
    )
);
